/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class CompositeInstallable_Test extends TestCase
{
    CompositeInstallable unit;
    CompositeInstallable clonedUnit;
    Element element;
    SPISessionImpl session;

    public CompositeInstallable_Test(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        super.setUp();

        unit = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeInstallable("id", "operation");

        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("conName", "conNameKey"));
        unit.setCondition(condition);

        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con1Name", "con1NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp1Expression", con1);
        Condition con2 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con2.setDisplayName(new TranslatableString("con2Name", "con2NameKey"));
        ConditionalDerivedVariableExpression exp2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp2Expression", con2);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var1ID", Arrays.asList(exp1, exp2));

        Condition con3 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con3.setDisplayName(new TranslatableString("con3Name", "con3NameKey"));
        ConditionalDerivedVariableExpression exp3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con3);
        Condition con4 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con4.setDisplayName(new TranslatableString("con4Name", "con4NameKey"));
        ConditionalDerivedVariableExpression exp4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp4Expression", con4);
        ConditionalDerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var2ID", Arrays.asList(exp3, exp4));
        unit.setConditionalDerivedVariables(Arrays.asList(var1, var2));
        
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar1ID", "dvar1Expression");
        DerivedVariable dvar2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar2ID", "dvar2Expression");
        unit.setDerivedVariables(Arrays.asList(dvar1, dvar2));
        
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("name", "nameKey"));
        unit.setIdentityData(identity);
        
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param1ID");
        BooleanParameter param2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param2ID");
        ParameterGroup paramGroup1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        paramGroup1.setBooleanParameters(Arrays.asList(param1, param2));
        BooleanParameter param3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param3ID");
        BooleanParameter param4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param4ID");
        ParameterGroup paramGroup2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        paramGroup2.setBooleanParameters(Arrays.asList(param3, param4));
        unit.setParameterGroups(Arrays.asList(paramGroup1, paramGroup2));
        
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        unit.setRequirements(Arrays.asList(req1, req2));
        
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop1ID", "prop1Ref");
        ResourceProperty prop2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop2ID", "prop2Ref");
        unit.setResourceProperties(Arrays.asList(prop1, prop2));

        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package1Ref", "package1ID");
        ReferencedPackage package2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package2Ref", "package2ID");
        unit.setContainedLocalizationPackages(Arrays.asList(package1, package2));

        ReferencedPackage package3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package3Ref", "package3ID");
        ReferencedPackage package4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package4Ref", "package4ID");
        CompositeLocalizationUnit comploc1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc1ID", Arrays.asList(package3, package4));
        ReferencedPackage package5 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package5Ref", "package5ID");
        ReferencedPackage package6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package6Ref", "package6ID");
        CompositeLocalizationUnit comploc2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc2ID", Arrays.asList(package5, package6));
        unit.setCompositeLocalizationUnits(Arrays.asList(comploc1, comploc2));

        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res1Ref");
        ResultingResource res2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res2Ref");
        unit.setResultingResources(Arrays.asList(res1, res2));
        
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("baseName", "baseKey"));
        unit.setRequiredBase(base);

        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art1ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu1ID", "lu1ResourceRef", art1, ContentUnitFactory.INSTALL_ARTIFACT);
        Artifact art2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art2.setContentReference("art2ContentRef");
        LocalizationUnit lu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu2ID", "lu2ResourceRef", art2, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setLocalizationUnits(Arrays.asList(lu1, lu2));

        CompositeUnit baseUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU1ID");
        CompositeUnit baseUnit2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU2ID");
        unit.setBaseCompositeUnits(Arrays.asList(baseUnit1, baseUnit2));

        Artifact baseArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt1.setContentReference("baseArt1ContentRef");
        ConfigurationUnit baseCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg1ID", "baseCfg1ResourceRef", baseArt1);
        Artifact baseArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt2.setContentReference("baseArt2ContentRef");
        ConfigurationUnit baseCfg2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg2ID", "baseCfg2ResourceRef", baseArt2);
        unit.setBaseConfigurationUnits(Arrays.asList(baseCfg1, baseCfg2));
        
        ReferencedPackage basePackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage1Ref", "basePackage1ID");
        ReferencedPackage basePackage2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage2Ref", "basePackage2ID");
        unit.setBaseContainedPackages(Arrays.asList(basePackage1, basePackage2));
        
        Artifact baseIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt1.setContentReference("baseIUArt1ContentRef");
        InstallableUnit baseIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU1ID", "baseIU1ResourceRef", baseIUArt1, ContentUnitFactory.INSTALL_ARTIFACT);
        Artifact baseIUArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt2.setContentReference("baseIUArt2ContentRef");
        InstallableUnit baseIU2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU2ID", "baseIU2ResourceRef", baseIUArt2, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setBaseInstallableUnits(Arrays.asList(baseIU1, baseIU2));
        
        CompositeUnit compUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU1ID");
        CompositeUnit compUnit2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU2ID");
        unit.setSelectableCompositeUnits(Arrays.asList(compUnit1, compUnit2));

        Artifact selArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt1.setContentReference("selArt1ContentRef");
        ConfigurationUnit selCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg1ID", "selCfg1ResourceRef", selArt1);
        Artifact selArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt2.setContentReference("selArt2ContentRef");
        ConfigurationUnit selCfg2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg2ID", "selCfg2ResourceRef", selArt2);
        unit.setSelectableConfigurationUnits(Arrays.asList(selCfg1, selCfg2));
        
        ReferencedPackage selPackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage1Ref", "selPackage1ID");
        ReferencedPackage selPackage2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage2Ref", "selPackage2ID");
        unit.setSelectableContainedPackages(Arrays.asList(selPackage1, selPackage2));
        
        Artifact selIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt1.setContentReference("selIUArt1ContentRef");
        InstallableUnit selIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU1ID", "selIU1ResourceRef", selIUArt1, ContentUnitFactory.INSTALL_ARTIFACT);
        Artifact selIUArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt2.setContentReference("selIUArt2ContentRef");
        InstallableUnit selIU2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU2ID", "selIU2ResourceRef", selIUArt2, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setSelectableInstallableUnits(Arrays.asList(selIU1, selIU2));
        
        DerivedVariable dvar3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar3ID", "dvar3Expression");
        DerivedVariable dvar4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar4ID", "dvar4Expression");
        Feature feature1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature1ID", Arrays.asList(dvar3, dvar4));
        DerivedVariable dvar5 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar5ID", "dvar5Expression");
        DerivedVariable dvar6 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar6ID", "dvar6Expression");
        Feature feature2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature2ID", Arrays.asList(dvar5, dvar6));
        unit.setFeatures(Arrays.asList(feature1, feature2));
        
        Group group1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group1ID", Arrays.asList("feature1Ref", "feature2Ref"));
        Group group2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group2ID", Arrays.asList("feature3Ref", "feature4Ref"));
        unit.setGroups(Arrays.asList(group1, group2));
        
        Language manLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang1Type");
        Language manLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang2Type");
        unit.setMandatoryLanguages(Arrays.asList(manLang1, manLang2));
        
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang1Type");
        Language optLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang2Type");
        unit.setOptionalLanguages(Arrays.asList(optLang1, optLang2));

        Language setLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang1Type");
        Language setLang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang2Type");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet(Arrays.asList(setLang1, setLang2));
        Language setLang3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang3Type");
        Language setLang4 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang4Type");
        LanguageSet langSet2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet(Arrays.asList(setLang3, setLang4));
        unit.setOptionalLanguageSets(Arrays.asList(langSet1, langSet2));

        MultiFeatureSelect multi1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect(Arrays.asList("multiFeature1", "multiFeature2"));
        MultiFeatureSelect multi2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect(Arrays.asList("multiFeature3", "multiFeature4"));
        unit.setMultiFeatureSelects(Arrays.asList(multi1, multi2));
        
        ResultingChange change1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change1.setName("change1Name");
        ResultingChange change2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change2.setName("change2Name");
        unit.setResultingChanges(Arrays.asList(change1, change2));
        
        clonedUnit = (CompositeInstallable) unit.clone();
        element = ((SPIDataObject) unit).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings()
    {
        Properties props = ((SPIDataObject) unit).getTranslatableStrings();
        
        assertEquals(7, props.size());
        assertEquals("conName", props.getProperty("conNameKey"));
        assertEquals("con1Name", props.getProperty("con1NameKey"));
        assertEquals("con2Name", props.getProperty("con2NameKey"));
        assertEquals("con3Name", props.getProperty("con3NameKey"));
        assertEquals("con4Name", props.getProperty("con4NameKey"));
        assertEquals("name", props.getProperty("nameKey"));
        assertEquals("baseName", props.getProperty("baseKey"));
    }

    public void testGetBaseCompositeUnits()
    {
        assertEquals(2, unit.getBaseCompositeUnits().size());
        assertEquals("baseCU1ID", unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        assertEquals("baseCU2ID", unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());

        assertEquals(2, clonedUnit.getBaseCompositeUnits().size());
        assertEquals("baseCU1ID", clonedUnit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        assertEquals("baseCU2ID", clonedUnit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());

        assertEquals(2, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").size());
        assertEquals("baseCU1ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("baseCU2ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetBaseConfigurationUnits()
    {
        assertEquals(2, unit.getBaseConfigurationUnits().size());
        assertEquals("baseCfg1ID", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("baseCfg1ResourceRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("baseArt1ContentRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        assertEquals("baseCfg2ID", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        assertEquals("baseCfg2ResourceRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        assertEquals("baseArt2ContentRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());

        assertEquals(2, clonedUnit.getBaseConfigurationUnits().size());
        assertEquals("baseCfg1ID", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("baseCfg1ResourceRef", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("baseArt1ContentRef", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        assertEquals("baseCfg2ID", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        assertEquals("baseCfg2ResourceRef", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        assertEquals("baseArt2ContentRef", clonedUnit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        assertEquals("baseCfg1ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("baseCfg1ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("baseArt1ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("baseCfg2ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("baseCfg2ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("baseArt2ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetBaseContainedPackages()
    {
        assertEquals(2, unit.getBaseContainedPackages().size());
        assertEquals("basePackage1ID", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("basePackage1Ref", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("basePackage2ID", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("basePackage2Ref", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getBaseContainedPackages().size());
        assertEquals("basePackage1ID", clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("basePackage1Ref", clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("basePackage2ID", clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("basePackage2Ref", clonedUnit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").size());
        assertEquals("basePackage1ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("basePackage1Ref", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("basePackage2ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("basePackage2Ref", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetBaseInstallableUnits()
    {
        assertEquals(2, unit.getBaseInstallableUnits().size());
        assertEquals("baseIU1ID", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("baseIU1ResourceRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("baseIUArt1ContentRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("baseIU2ID", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        assertEquals("baseIU2ResourceRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        assertEquals("baseIUArt2ContentRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, clonedUnit.getBaseInstallableUnits().size());
        assertEquals("baseIU1ID", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("baseIU1ResourceRef", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("baseIUArt1ContentRef", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("baseIU2ID", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        assertEquals("baseIU2ResourceRef", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        assertEquals("baseIUArt2ContentRef", clonedUnit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").size());
        assertEquals("baseIU1ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("baseIU1ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("baseIUArt1ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("baseIU2ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("baseIU2ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("baseIUArt2ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetMandatoryLanguages()
    {
        assertEquals(2, unit.getMandatoryLanguages().size());
        assertEquals("manLang1Type", unit.getMandatoryLanguages().toArray(new Language[0])[0].getType());
        assertEquals("manLang2Type", unit.getMandatoryLanguages().toArray(new Language[0])[1].getType());
        
        assertEquals(2, clonedUnit.getMandatoryLanguages().size());
        assertEquals("manLang1Type", clonedUnit.getMandatoryLanguages().toArray(new Language[0])[0].getType());
        assertEquals("manLang2Type", clonedUnit.getMandatoryLanguages().toArray(new Language[0])[1].getType());
        
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").size());
        assertEquals("manLang1Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        assertEquals("manLang2Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguages()
    {
        assertEquals(2, unit.getOptionalLanguages().size());
        assertEquals("optLang1Type", unit.getOptionalLanguages().toArray(new Language[0])[0].getType());
        assertEquals("optLang2Type", unit.getOptionalLanguages().toArray(new Language[0])[1].getType());
        
        assertEquals(2, clonedUnit.getOptionalLanguages().size());
        assertEquals("optLang1Type", clonedUnit.getOptionalLanguages().toArray(new Language[0])[0].getType());
        assertEquals("optLang2Type", clonedUnit.getOptionalLanguages().toArray(new Language[0])[1].getType());

        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").size());
        assertEquals("optLang1Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        assertEquals("optLang2Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOptionalLanguageSets()
    {
        assertEquals(2, unit.getOptionalLanguageSets().size());
        assertEquals(2, unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        assertEquals(2, unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().size());
        assertEquals("setLang1Type", unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("setLang2Type", unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        assertEquals("setLang3Type", unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("setLang4Type", unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());

        assertEquals(2, clonedUnit.getOptionalLanguageSets().size());
        assertEquals(2, clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        assertEquals(2, clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().size());
        assertEquals("setLang1Type", clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("setLang2Type", clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[1].getType());
        assertEquals("setLang3Type", clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("setLang4Type", clonedUnit.getOptionalLanguageSets().toArray(new LanguageSet[0])[1].getLanguages().toArray(new Language[0])[1].getType());

        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").size());
        assertEquals("setLang1Type", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        assertEquals("setLang2Type", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
        assertEquals("setLang3Type", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").toArray(new Element[0])[0].getAttribute("type"));
        assertEquals("setLang4Type", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[1], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetCompositeLocalizationUnits()
    {
        assertEquals(2, unit.getCompositeLocalizationUnits().size());
        assertEquals(2, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals(2, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        assertEquals("comploc1ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package3ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package3Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package4ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package4Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        assertEquals("comploc2ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        assertEquals("package5ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package5Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package6ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package6Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().size());
        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        assertEquals("comploc1ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package3ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package3Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package4ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package4Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        assertEquals("comploc2ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        assertEquals("package5ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package5Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package6ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package6Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").size());
        assertEquals("comploc1ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package3ID", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package3Ref", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("package4ID", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package4Ref", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
        assertEquals("comploc2ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package5ID", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package5Ref", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("package6ID", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package6Ref", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetCondition()
    {
        assertEquals("conName", unit.getCondition().getDisplayName().getValue());
        assertEquals("conNameKey", unit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("conName", clonedUnit.getCondition().getDisplayName().getValue());
        assertEquals("conNameKey", clonedUnit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("conName", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("conNameKey", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetContainedLocalizationPackages()
    {
        assertEquals(2, unit.getContainedLocalizationPackages().size());
        assertEquals("package1ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package1Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package2ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package2Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getContainedLocalizationPackages().size());
        assertEquals("package1ID", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package1Ref", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package2ID", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package2Ref", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals("package1ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package1Ref", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("package2ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package2Ref", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetFeatures()
    {
        assertEquals(2, unit.getFeatures().size());
        assertEquals(2, unit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        assertEquals(2, unit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        assertEquals("feature1ID", unit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        assertEquals("feature2ID", unit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        assertEquals("dvar3ID", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar3Expression", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar4ID", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar4Expression", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        assertEquals("dvar5ID", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar5Expression", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar6ID", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar6Expression", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(2, clonedUnit.getFeatures().size());
        assertEquals(2, clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        assertEquals(2, clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        assertEquals("feature1ID", clonedUnit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        assertEquals("feature2ID", clonedUnit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        assertEquals("dvar3ID", clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar3Expression", clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar4ID", clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar4Expression", clonedUnit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[1].getExpression());
        assertEquals("dvar5ID", clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar5Expression", clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar6ID", clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar6Expression", clonedUnit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").size());
        assertEquals("feature1ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("feature2ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("dvar3ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("dvar3Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar4ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("dvar4Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar5ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("dvar5Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar6ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("dvar6Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
   }

    public void testGetMultiFeatureSelects()
    {
        assertEquals(2, unit.getMultiFeatureSelects().size());
        assertEquals(2, unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        assertEquals(2, unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().size());
        assertEquals("multiFeature1", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        assertEquals("multiFeature2", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        assertEquals("multiFeature3", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[0]);
        assertEquals("multiFeature4", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[1]);

        assertEquals(2, clonedUnit.getMultiFeatureSelects().size());
        assertEquals(2, clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        assertEquals(2, clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().size());
        assertEquals("multiFeature1", clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        assertEquals("multiFeature2", clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        assertEquals("multiFeature3", clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[0]);
        assertEquals("multiFeature4", clonedUnit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[1].getFeatures().toArray(new String[0])[1]);

        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").size());
        assertEquals("multiFeature1", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        assertEquals("multiFeature2", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
        assertEquals("multiFeature3", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        assertEquals("multiFeature4", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[1], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetGroups()
    {
        assertEquals(2, unit.getGroups().size());
        assertEquals(2, unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        assertEquals(2, unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().size());
        assertEquals("group1ID", unit.getGroups().toArray(new Group[0])[0].getGroupID());
        assertEquals("feature1Ref", unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);
        assertEquals("feature2Ref", unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[1]);
        assertEquals("group2ID", unit.getGroups().toArray(new Group[0])[1].getGroupID());
        assertEquals("feature3Ref", unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[0]);
        assertEquals("feature4Ref", unit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[1]);

        assertEquals(2, clonedUnit.getGroups().size());
        assertEquals(2, clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        assertEquals(2, clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().size());
        assertEquals("group1ID", clonedUnit.getGroups().toArray(new Group[0])[0].getGroupID());
        assertEquals("feature1Ref", clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);
        assertEquals("feature2Ref", clonedUnit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[1]);
        assertEquals("group2ID", clonedUnit.getGroups().toArray(new Group[0])[1].getGroupID());
        assertEquals("feature3Ref", clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[0]);
        assertEquals("feature4Ref", clonedUnit.getGroups().toArray(new Group[0])[1].getSelectedFeatures().toArray(new String[0])[1]);

        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").size());
        assertEquals("group1ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("feature1Ref", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        assertEquals("feature2Ref", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
        assertEquals("group2ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("feature3Ref", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        assertEquals("feature4Ref", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[1], "SelectedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetLocalizationUnits()
    {
        assertEquals(2, unit.getLocalizationUnits().size());
        assertEquals("lu1ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu1ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art1ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("lu2ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        assertEquals("lu2ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        assertEquals("art2ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, clonedUnit.getLocalizationUnits().size());
        assertEquals("lu1ID", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu1ResourceRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art1ContentRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("lu2ID", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        assertEquals("lu2ResourceRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        assertEquals("art2ContentRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").size());
        assertEquals("lu1ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("lu1ResourceRef", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("art1ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("lu2ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("lu2ResourceRef", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("art2ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetRequiredBase()
    {
        assertEquals("baseName", unit.getRequiredBase().getDisplayName().getValue());
        assertEquals("baseKey", unit.getRequiredBase().getDisplayName().getTranslationKey());
        
        assertEquals("baseName", clonedUnit.getRequiredBase().getDisplayName().getValue());
        assertEquals("baseKey", clonedUnit.getRequiredBase().getDisplayName().getTranslationKey());

        assertEquals("baseName", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("baseKey", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetRequirements()
    {
        assertEquals(2, unit.getRequirements().size());
        assertEquals("req1ID", unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        assertEquals("req2ID", unit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        
        assertEquals(2, clonedUnit.getRequirements().size());
        assertEquals("req1ID", clonedUnit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        assertEquals("req2ID", clonedUnit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());

        assertEquals(2, session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        assertEquals("req1ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("req2ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetResultingChanges()
    {
        assertEquals(2, unit.getResultingChanges().size());
        assertEquals("change1Name", unit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());
        assertEquals("change2Name", unit.getResultingChanges().toArray(new ResultingChange[0])[1].getName());
        
        assertEquals(2, clonedUnit.getResultingChanges().size());
        assertEquals("change1Name", clonedUnit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());
        assertEquals("change2Name", clonedUnit.getResultingChanges().toArray(new ResultingChange[0])[1].getName());

        assertEquals(2, session.getChildren(element, "ResultingChange").size());
        assertEquals("change1Name", session.getChildren(session.getChildren(element, "ResultingChange").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("change2Name", session.getChildren(session.getChildren(element, "ResultingChange").toArray(new Element[0])[1], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetResultingResources()
    {
        assertEquals(2, unit.getResultingResources().size());
        assertEquals("res1Ref", unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        assertEquals("res2Ref", unit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        
        assertEquals(2, clonedUnit.getResultingResources().size());
        assertEquals("res1Ref", clonedUnit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        assertEquals("res2Ref", clonedUnit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());

        assertEquals(2, session.getChildren(element, "ResultingResource").size());
        assertEquals("res1Ref", (session.getChildren(element, "ResultingResource").toArray(new Element[0])[0]).getAttribute("resourceRef"));
        assertEquals("res2Ref", (session.getChildren(element, "ResultingResource").toArray(new Element[0])[1]).getAttribute("resourceRef"));
    }

    public void testGetSelectableCompositeUnits()
    {
        assertEquals(2, unit.getSelectableCompositeUnits().size());
        assertEquals("selCU1ID", unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        assertEquals("selCU2ID", unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());

        assertEquals(2, clonedUnit.getSelectableCompositeUnits().size());
        assertEquals("selCU1ID", clonedUnit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        assertEquals("selCU2ID", clonedUnit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());

        assertEquals(2, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").size());
        assertEquals("selCU1ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selCU2ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetSelectableConfigurationUnits()
    {
        assertEquals(2, unit.getSelectableConfigurationUnits().size());
        assertEquals("selCfg1ID", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("selCfg1ResourceRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("selArt1ContentRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        assertEquals("selCfg2ID", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        assertEquals("selCfg2ResourceRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        assertEquals("selArt2ContentRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());

        assertEquals(2, clonedUnit.getSelectableConfigurationUnits().size());
        assertEquals("selCfg1ID", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("selCfg1ResourceRef", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("selArt1ContentRef", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        assertEquals("selCfg2ID", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        assertEquals("selCfg2ResourceRef", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        assertEquals("selArt2ContentRef", clonedUnit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        assertEquals("selCfg1ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selCfg1ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("selArt1ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("selCfg2ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("selCfg2ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("selArt2ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetSelectableContainedPackages()
    {
        assertEquals(2, unit.getSelectableContainedPackages().size());
        assertEquals("selPackage1ID", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("selPackage1Ref", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("selPackage2ID", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("selPackage2Ref", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getSelectableContainedPackages().size());
        assertEquals("selPackage1ID", clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("selPackage1Ref", clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("selPackage2ID", clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("selPackage2Ref", clonedUnit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").size());
        assertEquals("selPackage1ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selPackage1Ref", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("selPackage2ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("selPackage2Ref", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetSelectableInstallableUnits()
    {
        assertEquals(2, unit.getSelectableInstallableUnits().size());
        assertEquals("selIU1ID", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("selIU1ResourceRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("selIUArt1ContentRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("selIU2ID", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        assertEquals("selIU2ResourceRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        assertEquals("selIUArt2ContentRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, clonedUnit.getSelectableInstallableUnits().size());
        assertEquals("selIU1ID", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("selIU1ResourceRef", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("selIUArt1ContentRef", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("selIU2ID", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        assertEquals("selIU2ResourceRef", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        assertEquals("selIUArt2ContentRef", clonedUnit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").size());
        assertEquals("selIU1ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selIU1ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("selIUArt1ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("selIU2ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("selIU2ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("selIUArt2ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetContentUnitID()
    {
        assertEquals("id", unit.getContentUnitID());
        assertEquals("id", clonedUnit.getContentUnitID());
        assertEquals("id", element.getAttribute("id"));
    }

    public void testGetIdentityData()
    {
        assertEquals("name", unit.getIdentityData().getName().getValue());
        assertEquals("nameKey", unit.getIdentityData().getName().getTranslationKey());
        
        assertEquals("name", clonedUnit.getIdentityData().getName().getValue());
        assertEquals("nameKey", clonedUnit.getIdentityData().getName().getTranslationKey());

        assertEquals("name", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("nameKey", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDerivedVariables()
    {
        assertEquals(2, unit.getDerivedVariables().size());
        assertEquals("dvar1ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar1Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar2ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar2Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(2, clonedUnit.getDerivedVariables().size());
        assertEquals("dvar1ID", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar1Expression", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar2ID", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar2Expression", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(4, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("dvar1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("dvar1Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3].getAttribute("id"));
        assertEquals("dvar2Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetConditionalDerivedVariables()
    {
        assertEquals(2, unit.getConditionalDerivedVariables().size());
        assertEquals("var1ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp1Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con1Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con1NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp2Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con2Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con2NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        assertEquals("var2ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        assertEquals("exp3Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con3Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con3NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp4Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con4Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con4NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());

        assertEquals(2, clonedUnit.getConditionalDerivedVariables().size());
        assertEquals("var1ID", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp1Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con1Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con1NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp2Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con2Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con2NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        assertEquals("var2ID", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        assertEquals("exp3Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con3Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con3NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp4Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con4Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con4NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());

        assertEquals(4, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("var1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("exp1Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con1Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con1NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("exp2Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con2Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con2NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("var2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("exp3Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con3Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con3NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("exp4Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con4Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con4NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetResourceProperties()
    {
        assertEquals(2, unit.getResourceProperties().size());
        assertEquals("prop1ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop1Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        assertEquals("prop2ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        assertEquals("prop2Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());

        assertEquals(2, clonedUnit.getResourceProperties().size());
        assertEquals("prop1ID", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop1Ref", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        assertEquals("prop2ID", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        assertEquals("prop2Ref", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        assertEquals("prop1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("prop1Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
        assertEquals("prop2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("prop2Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetParameterGroups()
    {
        assertEquals(2, unit.getParameterGroups().size());
        assertEquals(2, unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals(2, unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        assertEquals("param1ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param2ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        assertEquals("param3ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param4ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());

        assertEquals(2, clonedUnit.getParameterGroups().size());
        assertEquals(2, clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals(2, clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        assertEquals("param1ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param2ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        assertEquals("param3ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param4ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());

        assertEquals(2, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").size());
        assertEquals("param1ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("param2ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("param3ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("param4ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testSetBaseCompositeUnits()
    {
        CompositeUnit baseUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("baseCU3ID");
        unit.setBaseCompositeUnits(Arrays.asList(baseUnit1));

        assertEquals(1, unit.getBaseCompositeUnits().size());
        assertEquals("baseCU3ID", unit.getBaseCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());

        assertEquals(1, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").size());
        assertEquals("baseCU3ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetBaseConfigurationUnits()
    {
        Artifact baseArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        baseArt1.setContentReference("baseArt3ContentRef");
        ConfigurationUnit baseCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("baseCfg3ID", "baseCfg3ResourceRef", baseArt1);
        unit.setBaseConfigurationUnits(Arrays.asList(baseCfg1));

        assertEquals(1, unit.getBaseConfigurationUnits().size());
        assertEquals("baseCfg3ID", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("baseCfg3ResourceRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("baseArt3ContentRef", unit.getBaseConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        assertEquals("baseCfg3ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("baseCfg3ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("baseArt3ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetBaseContainedPackages()
    {
        ReferencedPackage basePackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("basePackage3Ref", "basePackage3ID");
        unit.setBaseContainedPackages(Arrays.asList(basePackage1));

        assertEquals(1, unit.getBaseContainedPackages().size());
        assertEquals("basePackage3ID", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("basePackage3Ref", unit.getBaseContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").size());
        assertEquals("basePackage3ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("basePackage3Ref", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetBaseInstallableUnits()
    {
        Artifact baseIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        baseIUArt1.setContentReference("baseIUArt3ContentRef");
        InstallableUnit baseIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("baseIU3ID", "baseIU3ResourceRef", baseIUArt1, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setBaseInstallableUnits(Arrays.asList(baseIU1));
        
        assertEquals(1, unit.getBaseInstallableUnits().size());
        assertEquals("baseIU3ID", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("baseIU3ResourceRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("baseIUArt3ContentRef", unit.getBaseInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").size());
        assertEquals("baseIU3ID", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("baseIU3ResourceRef", session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("baseIUArt3ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "BaseContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetMandatoryLanguages()
    {
        Language manLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("manLang3Type");
        unit.setMandatoryLanguages(Arrays.asList(manLang1));
        
        assertEquals(1, unit.getMandatoryLanguages().size());
        assertEquals("manLang3Type", unit.getMandatoryLanguages().toArray(new Language[0])[0].getType());

        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").size());
        assertEquals("manLang3Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Mandatory").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguages()
    {
        Language optLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("optLang3Type");
        unit.setOptionalLanguages(Arrays.asList(optLang1));

        assertEquals(1, unit.getOptionalLanguages().size());
        assertEquals("optLang3Type", unit.getOptionalLanguages().toArray(new Language[0])[0].getType());

        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").size());
        assertEquals("optLang3Type", session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOptionalLanguageSets()
    {
        Language setLang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("setLang4Type");
        LanguageSet langSet1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet(Arrays.asList(setLang1));
        unit.setOptionalLanguageSets(Arrays.asList(langSet1));

        assertEquals(1, unit.getOptionalLanguageSets().size());
        assertEquals(1, unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().size());
        assertEquals("setLang4Type", unit.getOptionalLanguageSets().toArray(new LanguageSet[0])[0].getLanguages().toArray(new Language[0])[0].getType());

        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").size());
        assertEquals("setLang4Type", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Optional").toArray(new Element[0])[0], "LanguageSet").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetCompositeLocalizationUnits()
    {
        ReferencedPackage package8 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package8Ref", "package8ID");
        CompositeLocalizationUnit comploc3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc3ID", Arrays.asList(package8));
        unit.setCompositeLocalizationUnits(Arrays.asList(comploc3));

        assertEquals(1, unit.getCompositeLocalizationUnits().size());
        assertEquals(1, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals("comploc3ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package8ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package8Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals("comploc3ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package8ID", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package8Ref", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetCondition()
    {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        unit.setCondition(condition);
        
        assertEquals("differentName", unit.getCondition().getDisplayName().getValue());
        assertEquals("differentNameKey", unit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("differentName", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentNameKey", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetContainedLocalizationPackages()
    {
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package7Ref", "package7ID");
        unit.setContainedLocalizationPackages(Arrays.asList(package1));

        assertEquals(1, unit.getContainedLocalizationPackages().size());
        assertEquals("package7ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package7Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals("package7ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package7Ref", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetFeatures()
    {
        DerivedVariable dvar7 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar7ID", "dvar7Expression");
        Feature feature3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature3ID", Arrays.asList(dvar7));
        DerivedVariable dvar8 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar8ID", "dvar8Expression");
        Feature feature4 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature4ID", Arrays.asList(dvar8));
        DerivedVariable dvar9 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createVariable("dvar9ID", "dvar9Expression");
        Feature feature5 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createFeatureWithDerivedVariables("feature5ID", Arrays.asList(dvar9));
        unit.setFeatures(Arrays.asList(feature3, feature4, feature5));

        assertEquals(3, unit.getFeatures().size());
        assertEquals(1, unit.getFeatures().toArray(new Feature[0])[0].getVariables().size());
        assertEquals(1, unit.getFeatures().toArray(new Feature[0])[1].getVariables().size());
        assertEquals("feature3ID", unit.getFeatures().toArray(new Feature[0])[0].getFeatureID());
        assertEquals("feature4ID", unit.getFeatures().toArray(new Feature[0])[1].getFeatureID());
        assertEquals("feature5ID", unit.getFeatures().toArray(new Feature[0])[2].getFeatureID());
        assertEquals("dvar7ID", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar7Expression", unit.getFeatures().toArray(new Feature[0])[0].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar8ID", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar8Expression", unit.getFeatures().toArray(new Feature[0])[1].getVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar9ID", unit.getFeatures().toArray(new Feature[0])[2].getVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar9Expression", unit.getFeatures().toArray(new Feature[0])[2].getVariables().toArray(new DerivedVariable[0])[0].getExpression());

        assertEquals(3, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").size());
        assertEquals("feature3ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("feature4ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("feature5ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("dvar7ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("dvar7Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar8ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("dvar8Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar9ID", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2], "Variable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("dvar9Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2], "Variable").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetMultiFeatureSelects()
    {
        MultiFeatureSelect multi1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect(Arrays.asList("multiFeature5", "multiFeature6", "multiFeature7"));
        unit.setMultiFeatureSelects(Arrays.asList(multi1));
        
        assertEquals(1, unit.getMultiFeatureSelects().size());
        assertEquals(3, unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().size());
        assertEquals("multiFeature5", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[0]);
        assertEquals("multiFeature6", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[1]);
        assertEquals("multiFeature7", unit.getMultiFeatureSelects().toArray(new MultiFeatureSelect[0])[0].getFeatures().toArray(new String[0])[2]);

        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").size());
        assertEquals(3, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").size());
        assertEquals("multiFeature5", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        assertEquals("multiFeature6", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
        assertEquals("multiFeature7", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Features").toArray(new Element[0])[0], "MultiSelect").toArray(new Element[0])[0], "Feature").toArray(new Element[0])[2].getAttribute("featureRef"));
    }

    public void testSetGroups()
    {
        Group group1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("group3ID", Arrays.asList("feature3Ref"));
        unit.setGroups(Arrays.asList(group1));
        
        assertEquals(1, unit.getGroups().size());
        assertEquals(1, unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().size());
        assertEquals("group3ID", unit.getGroups().toArray(new Group[0])[0].getGroupID());
        assertEquals("feature3Ref", unit.getGroups().toArray(new Group[0])[0].getSelectedFeatures().toArray(new String[0])[0]);

        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").size());
        assertEquals("group3ID", session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("feature3Ref", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "Groups").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0], "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
    }

    public void testSetLocalizationUnits()
    {
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art3ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu3ID", "lu3ResourceRef", art1, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setLocalizationUnits(Arrays.asList(lu1));
        
        assertEquals(1, unit.getLocalizationUnits().size());
        assertEquals("lu3ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu3ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art3ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").size());
        assertEquals("lu3ID", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("lu3ResourceRef", session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("art3ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "LocalizationContent").toArray(new Element[0])[0], "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetRequiredBase()
    {
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("differentName", "differentKey"));
        unit.setRequiredBase(base);
        
        assertEquals("differentName", unit.getRequiredBase().getDisplayName().getValue());
        assertEquals("differentKey", unit.getRequiredBase().getDisplayName().getTranslationKey());
        
        assertEquals("differentName", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentKey", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetRequirements()
    {
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req3ID");
        unit.setRequirements(Arrays.asList(req1));
        
        assertEquals(1, unit.getRequirements().size());
        assertEquals("req3ID", unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());

        assertEquals(1, session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        assertEquals("req3ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetResultingChanges()
    {
        ResultingChange change1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingChange();
        change1.setName("change3Name");
        unit.setResultingChanges(Arrays.asList(change1));

        assertEquals(1, unit.getResultingChanges().size());
        assertEquals("change3Name", unit.getResultingChanges().toArray(new ResultingChange[0])[0].getName());

        assertEquals(1, session.getChildren(element, "ResultingChange").size());
        assertEquals("change3Name", session.getChildren(session.getChildren(element, "ResultingChange").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetResultingResources()
    {
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res3Ref");
        unit.setResultingResources(Arrays.asList(res1));

        assertEquals(1, unit.getResultingResources().size());
        assertEquals("res3Ref", unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());

        assertEquals(1, session.getChildren(element, "ResultingResource").size());
        assertEquals("res3Ref", (session.getChildren(element, "ResultingResource").toArray(new Element[0])[0]).getAttribute("resourceRef"));
    }

    public void testSetSelectableCompositeUnits()
    {
        CompositeUnit selUnit1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("selCU3ID");
        unit.setSelectableCompositeUnits(Arrays.asList(selUnit1));

        assertEquals(1, unit.getSelectableCompositeUnits().size());
        assertEquals("selCU3ID", unit.getSelectableCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());

        assertEquals(1, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").size());
        assertEquals("selCU3ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetSelectableConfigurationUnits()
    {
        Artifact selArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        selArt1.setContentReference("selArt3ContentRef");
        ConfigurationUnit selCfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("selCfg3ID", "selCfg3ResourceRef", selArt1);
        unit.setSelectableConfigurationUnits(Arrays.asList(selCfg1));

        assertEquals(1, unit.getSelectableConfigurationUnits().size());
        assertEquals("selCfg3ID", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        assertEquals("selCfg3ResourceRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        assertEquals("selArt3ContentRef", unit.getSelectableConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").size());
        assertEquals("selCfg3ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selCfg3ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("selArt3ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetSelectableContainedPackages()
    {
        ReferencedPackage selPackage1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("selPackage3Ref", "selPackage3ID");
        unit.setSelectableContainedPackages(Arrays.asList(selPackage1));

        assertEquals(1, unit.getSelectableContainedPackages().size());
        assertEquals("selPackage3ID", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("selPackage3Ref", unit.getSelectableContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").size());
        assertEquals("selPackage3ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selPackage3Ref", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetSelectableInstallableUnits()
    {
        Artifact selIUArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        selIUArt1.setContentReference("selIUArt3ContentRef");
        InstallableUnit selIU1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("selIU3ID", "selIU3ResourceRef", selIUArt1, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setSelectableInstallableUnits(Arrays.asList(selIU1));
        
        assertEquals(1, unit.getSelectableInstallableUnits().size());
        assertEquals("selIU3ID", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        assertEquals("selIU3ResourceRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        assertEquals("selIUArt3ContentRef", unit.getSelectableInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").size());
        assertEquals("selIU3ID", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("selIU3ResourceRef", session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("selIUArt3ContentRef", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "SelectableContent").toArray(new Element[0])[0], "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetContentUnitID()
    {
        unit.setContentUnitID("differentID");
        
        assertEquals("differentID", unit.getContentUnitID());
        assertEquals("differentID", element.getAttribute("id"));
    }

    public void testSetIdentityData()
    {
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("differentName", "differentNameKey"));
        unit.setIdentityData(identity);
        
        assertEquals("differentName", unit.getIdentityData().getName().getValue());
        assertEquals("differentNameKey", unit.getIdentityData().getName().getTranslationKey());
        
        assertEquals("differentName", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentNameKey", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetResourceProperties()
    {
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop3ID", "prop3Ref");
        unit.setResourceProperties(Arrays.asList(prop1));
        
        assertEquals(1, unit.getResourceProperties().size());
        assertEquals("prop3ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop3Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        assertEquals("prop3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("prop3Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetDerivedVariables()
    {
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar3ID", "dvar3Expression");
        unit.setDerivedVariables(Arrays.asList(dvar1));
        
        assertEquals(1, unit.getDerivedVariables().size());
        assertEquals("dvar3ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar3Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());

        assertEquals(3, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("dvar3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("dvar3Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetConditionalDerivedVariables()
    {
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con5Name", "con5NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con1);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var3ID", Arrays.asList(exp1));
        unit.setConditionalDerivedVariables(Arrays.asList(var1));
        
        assertEquals(1, unit.getConditionalDerivedVariables().size());
        assertEquals("var3ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp3Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con5Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con5NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());

        assertEquals(3, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("var3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("exp3Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con5Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con5NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetParameterGroups()
    {
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param5ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters(Arrays.asList(param1));
        unit.setParameterGroups(Arrays.asList(group1));

        assertEquals(1, unit.getParameterGroups().size());
        assertEquals(1, unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals("param5ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());

        assertEquals(1, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        assertEquals("param5ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
    }
    
}
