/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.w3c.dom.Element;

public class ConstrainedResource_Test extends TestCase
{
    ConstrainedResource resource;
    ConstrainedResource clonedResource;
    Element element;

    public ConstrainedResource_Test(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        super.setUp();
        
        resource = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConstrainedResource("resourceRef");
        
        resource.setConstraintType("resourceType");
        
        clonedResource = (ConstrainedResource) resource;
        element = ((SPIDataObject) resource).getElement();
    }

    public void testGetConstraintType()
    {
        assertEquals("resourceType", resource.getConstraintType());
        assertEquals("resourceType", clonedResource.getConstraintType());
        assertEquals("resourceType", element.getAttribute("constraintType"));
    }

    public void testGetResourceRef()
    {
        assertEquals("resourceRef", resource.getResourceRef());
        assertEquals("resourceRef", clonedResource.getResourceRef());
        assertEquals("resourceRef", element.getAttribute("resourceRef"));
    }

    public void testSetConstraintType()
    {
        resource.setConstraintType("differentType");
        
        assertEquals("differentType", resource.getConstraintType());
        assertEquals("differentType", element.getAttribute("constraintType"));
    }

    public void testSetResourceRef()
    {
        resource.setResourceRef("differentRef");

        assertEquals("differentRef", resource.getResourceRef());
        assertEquals("differentRef", clonedResource.getResourceRef());
        assertEquals("differentRef", element.getAttribute("resourceRef"));
    }

    public void testGetTranslatableStrings()
    {
        Properties props = ((SPIDataObject) resource).getTranslatableStrings();
        
        assertEquals(0, props.size());
    }

}
