/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.math.BigInteger;
import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.w3c.dom.Element;

public class MultiFeatureSelect_Test extends TestCase {
    MultiFeatureSelect featureSelect;
    MultiFeatureSelect clonedFeatureSelect;
    Element element;
    SPISessionImpl session;

    public MultiFeatureSelect_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        featureSelect = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect(Arrays.asList("feature1", "feature2"));

        featureSelect.setMaxSelections(BigInteger.valueOf(5));
        featureSelect.setMinSelections(BigInteger.valueOf(4));
        
        clonedFeatureSelect = (MultiFeatureSelect)featureSelect.clone();
        element = ((SPIDataObject)featureSelect).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        assertEquals(0, ((SPIDataObject)featureSelect).getTranslatableStrings().size());
    }

    public void testGetFeatures() {
        assertEquals(2, featureSelect.getFeatures().size());
        assertEquals(2, clonedFeatureSelect.getFeatures().size());
        assertEquals(2, session.getChildren(element, "Feature").size());
        
        assertEquals("feature1", featureSelect.getFeatures().toArray(new String[0])[0]);
        assertEquals("feature2", featureSelect.getFeatures().toArray(new String[0])[1]);
        
        assertEquals("feature1", clonedFeatureSelect.getFeatures().toArray(new String[0])[0]);
        assertEquals("feature2", clonedFeatureSelect.getFeatures().toArray(new String[0])[1]);
        
        assertEquals("feature1", ( session.getChildren(element, "Feature").toArray(new Element[0])[0]).getAttribute("featureRef"));
        assertEquals("feature2", ( session.getChildren(element, "Feature").toArray(new Element[0])[1]).getAttribute("featureRef"));
    }

    public void testGetMaximumSelections() {
        assertEquals(5, featureSelect.getMaxSelections().intValue());
        assertEquals(5, clonedFeatureSelect.getMaxSelections().intValue());
        assertEquals(5, Integer.parseInt(element.getAttribute("maxSelections")));
    }

    public void testGetMinimumSelections() {
        assertEquals(4, featureSelect.getMinSelections().intValue());
        assertEquals(4, clonedFeatureSelect.getMinSelections().intValue());
        assertEquals(4, Integer.parseInt(element.getAttribute("minSelections")));
    }

    public void testSetFeatures() {
        featureSelect.setFeatures(Arrays.asList("feature3", "feature4", "feature5"));
        
        assertEquals(3, featureSelect.getFeatures().size());
        assertEquals(3, session.getChildren(element, "Feature").size());
        
        assertEquals("feature3", featureSelect.getFeatures().toArray(new String[0])[0]);
        assertEquals("feature4", featureSelect.getFeatures().toArray(new String[0])[1]);
        assertEquals("feature5", featureSelect.getFeatures().toArray(new String[0])[2]);
        
        assertEquals("feature3", ( session.getChildren(element, "Feature").toArray(new Element[0])[0]).getAttribute("featureRef"));
        assertEquals("feature4", ( session.getChildren(element, "Feature").toArray(new Element[0])[1]).getAttribute("featureRef"));
        assertEquals("feature5", ( session.getChildren(element, "Feature").toArray(new Element[0])[2]).getAttribute("featureRef"));
        
        try {
            featureSelect.setFeatures(Arrays.asList("feature"));
            fail("Features set to only one feature");
        }
        catch (Exception e) {
        }
        
        try {
            featureSelect.setFeatures(null);
            fail("Features set to null");
        }
        catch (Exception e) {
        }
    }

    public void testSetMaximumSelections() {
        featureSelect.setMaxSelections(BigInteger.valueOf(6));

        assertEquals(6, featureSelect.getMaxSelections().intValue());
        assertEquals(6, Integer.parseInt(element.getAttribute("maxSelections")));
    }

    public void testSetMinimumSelections() {
        featureSelect.setMinSelections(BigInteger.valueOf(2));

        assertEquals(2, featureSelect.getMinSelections().intValue());
        assertEquals(2, Integer.parseInt(element.getAttribute("minSelections")));
    }
}
