/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.w3c.dom.Element;

public class PackageFeatureReference_Test extends TestCase {
    PackageFeatureReference featureRef;
    PackageFeatureReference clonedFeatureRef;
    Element element;

    public PackageFeatureReference_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        featureRef = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createPackageFeatureReference("contentRef", "featureRef");
        
        clonedFeatureRef = (PackageFeatureReference) featureRef.clone();
        element = ((SPIDataObject)featureRef).getElement();
    }

    public void testGetContentElementRef() {
        assertEquals("contentRef", featureRef.getContentElementRef());
        assertEquals("contentRef", clonedFeatureRef.getContentElementRef());
        assertEquals("contentRef", element.getAttribute("contentElementRef"));
    }

    public void testGetPackageFeatureRef() {
        assertEquals("featureRef", featureRef.getPackageFeatureRef());
        assertEquals("featureRef", clonedFeatureRef.getPackageFeatureRef());
        assertEquals("featureRef", element.getAttribute("packageFeatureRef"));
    }

    public void testSetContentElementRef() {
        featureRef.setContentElementRef("differentRef");
        
        assertEquals("differentRef", featureRef.getContentElementRef());
        assertEquals("differentRef", element.getAttribute("contentElementRef"));
        
        try {
            featureRef.setContentElementRef(null);
            fail("ContentElementRef set to null");
        }
        catch (Exception e) {
        }
    }

    public void testSetPackageFeatureRef() {
        featureRef.setPackageFeatureRef("differentFeatureRef");
        
        assertEquals("differentFeatureRef", featureRef.getPackageFeatureRef());
        assertEquals("differentFeatureRef", element.getAttribute("packageFeatureRef"));

        try {
            featureRef.setPackageFeatureRef(null);
            fail("PackageFeatureRef set to null");
        }
        catch (Exception e) {
        }
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)featureRef).getTranslatableStrings();
        
        assertEquals(0, props.keySet().size());
    }
}
