/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Collection;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;

public class Relationship_Test extends TestCase {
    Relationship rel;
    Relationship clonedRel;
    Element element;
    SPISessionImpl session;

    public Relationship_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        rel = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createRelationship("relResourceRef", "relType");
        
        Properties props = new Properties();
        props.setProperty("key1", "value1");
        props.setProperty("key2", "value2");
        rel.setProperties(props);

        clonedRel = (Relationship)rel.clone();
        element = ((SPIDataObject)rel).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetProperties() {
        Properties testProps = rel.getProperties();
        Properties testclonedProps = clonedRel.getProperties();
        Collection<Element> testDataObjectProps = session.getChildren(element, "Property");
        
        assertEquals("value1", testProps.get("key1"));
        assertEquals("value2", testProps.get("key2"));
        assertEquals("value1", testclonedProps.get("key1"));
        assertEquals("value2", testclonedProps.get("key2"));
        
        assertEquals(2, testDataObjectProps.size());
        
        for (int i = 0; i < testDataObjectProps.size(); i++) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            
            String value = session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            
            assertTrue(value + " wasn't found in the properties object", testProps.contains(value));
            assertTrue(propertyName + " wasn't found in the properties object", testProps.containsKey(propertyName));
            assertEquals(value, testProps.get(propertyName));
        }
    }

    public void testGetRelatedResourceReference() {
        assertEquals("relResourceRef", rel.getRelatedResourceReference());
        assertEquals("relResourceRef", clonedRel.getRelatedResourceReference());
        assertEquals("relResourceRef", element.getAttribute("relatedResourceRef"));
    }

    public void testGetType() {
        assertEquals("relType", rel.getType());
        assertEquals("relType", clonedRel.getType());
        assertEquals("relType", element.getAttribute("type"));
    }

    public void testSetProperties() {
        Properties props = new Properties();
        props.setProperty("key3", "value3");
        rel.setProperties(props);

        Properties testProps = rel.getProperties();
        Collection<Element> testDataObjectProps = session.getChildren(element, "Property");
        
        assertEquals(1, testDataObjectProps.size());

        assertEquals("value3", testProps.get("key3"));
        
        for (int i = 0; i < testDataObjectProps.size(); i++) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            
            String value = session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            
            assertTrue(value + " wasn't found in the properties object", testProps.contains(value));
            assertTrue(propertyName + " wasn't found in the properties object", testProps.containsKey(propertyName));
            assertEquals(value, testProps.get(propertyName));
        }
    }

    public void testSetRelatedResourceReference() {
        rel.setRelatedResourceReference("differentRef");
        
        assertEquals("differentRef", rel.getRelatedResourceReference());
        assertEquals("differentRef", element.getAttribute("relatedResourceRef"));
        
        try {
            rel.setRelatedResourceReference(null);
            
            fail("RelatedResourceRef was set to null");
        }
        catch (Exception e) {
        }
    }

    public void testSetType() {
        rel.setType("differentType");
        
        assertEquals("differentType", rel.getType());
        assertEquals("differentType", element.getAttribute("type"));
        
        try {
            rel.setType(null);
            
            fail("Type was set to null");
        }
        catch (Exception e) {
        }
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)rel).getTranslatableStrings();
        
        assertEquals(0, props.keySet().size());
    }
}
