/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;



/**
 * Fix Identity objects describe fixes that will be applied as part
 * of a containing solution package. 
 *
 */
public interface FixIdentity extends Describable {
	/**
	 * Gets the FixName.
	 * 
	 * The Name element MUST provide a value that uniquely identifies a fix within a scope defined by the manufacturer. This is a 
	 * name provided by the manufacturer that corresponds to the fix name as understood in the deployment environment.
	 *  
	 * @return A name for the fix which is, at a minimum, unique within the scope of the resource fixed.
	 */
	String getFixName();
	
	/**
	 * Gets the Symptoms.
	 * 
	 * Symptom strings can be used to correlate a fix with one or more experienced problems.
	 * 
	 * @return A collection of TranslatableString objects that describes the symptoms of the problem fixed.
	 */
	Collection<TranslatableString> getSymptoms();
	
	/**
	 * Sets the FixName.
	 * 
	 * The Name element MUST provide a value that uniquely identifies a fix within a scope defined by the manufacturer. This is a 
	 * name provided by the manufacturer that corresponds to the fix name as understood in the deployment environment.
	 * 
	 * @param fixName A name for the fix which is, at a minimum, unique within the scope of the resource fixed.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setFixName(String fixName);
	
	/**
	 * Sets the Symptoms.
	 * 
	 * Symptom strings can be used to correlate a fix with one or more experienced problems.
	 * 
	 * @param symptoms A collection of TranslatableString objects that describes the symptoms of the problem fixed.
	 */
	void setSymptoms(Collection<TranslatableString> symptoms);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
