/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;



/**
 * The SDD author can include information about the package manufacturer that includes name, location and contact information such 
 * as the address of the manufacturers Web site or telephone number.
 */
public interface ManufacturerInformation {
	
	/**
	 * Gets the Name.
	 * 
	 * The value provided in the Name element MUST be an identifiable name of the manufacturer of the SDD. 
	 * 
	 * @return A translatable name for the manufacturer.
	 */
	TranslatableString getName();
	
	/**
	 * Gets the Contact Information.
	 * 
	 * This element MAY provide additional contact information for the named manufacturer, such as a support Web site address or a 
	 * technical support telephone number.
	 * 
	 * @return Contact information for the manufacturer.
	 */
	TranslatableString getContactInformation();
	
	/**
	 * Gets the Address.
	 * 
	 * This is the mailing address or the physical address.
	 * 
	 * @return The manufacturers address.
	 */
	TranslatableString getAddress();
	
	/**
	 * Gets the Country.
	 * 
	 * Recording the manufacturers country in the SDD provides information that may be of interest in relation to import and 
	 * export of software.
	 * 
	 * @return The manufacturers country.
	 */
	TranslatableString getCountry();
	
	/**
	 * Sets the Name.
	 * 
	 * The value provided in the Name element MUST be an identifiable name of the manufacturer of the SDD. 
	 * 
	 * @param name A non-null Manufacturer's name
	 * @throws InvalidInputException if the parameter is null
	 */
	void setName(TranslatableString name);

	/**
	 * Sets the Contact information.
	 * 
	 * This element MAY provide additional contact information for the named manufacturer, such as a support Web site address or a 
	 * technical support telephone number.
	 * 
	 * @param contactInformation Contact information for the manufacturer.
	 */
	void setContactInformation(TranslatableString contactInformation);
	
	/**
	 * Sets the Address.
	 * 
	 * This is the mailing address or the physical address.
	 * 
	 * @param address The manufacturers address.
	 */
	void setAddress(TranslatableString address);
	
	/**
	 * Sets the Country.
	 * 
	 * Recording the manufacturers country in the SDD provides information that may be of interest in relation to import and 
	 * export of software.
	 * 
	 * @param country The manufacturers country.
	 */
	void setCountry(TranslatableString country);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
