/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BaseVariable;

/**
 * ResourcePropertyType provides the type definition for the ResourceProperty element of VariablesType. ResourceProperty is 
 * a variable whose value is set from the property of a specific instance of a resource during a particular solution deployment. 
 * All content elements can define ResourceProperty elements. 
 */
public interface ResourceProperty extends BaseVariable {
	
	/**
	 * Gets the property name.
	 * 
	 * The propertyName attribute identifies the name of the resource property whose value is to be used as the value of 
	 * ResourceProperty
	 * 
	 * @return Name of the property whose value provides the variables values.
	 */
	String getPropertyName();
	
	/**
	 * Gets the resource reference.
	 * 
	 * The resourceRef attribute MUST identify the resource in Topology that owns the property and will provide the value for 
	 * ResourceProperty.
	 * 
	 * @return The resource in Topology that owns the property.
	 */
	String getResourceReference();
	
	
	/**
	 * Sets the property name.
	 * 
	 * The propertyName attribute identifies the name of the resource property whose value is to be used as the value of 
	 * ResourceProperty
	 * 
	 * @param propertyName Name of the property whose value provides the variables values.
	 */
	void setPropertyName(String propertyName);
	
	/**
	 * Sets the resource reference.
	 * 
	 * The resourceRef attribute MUST identify the resource in Topology that owns the property and will provide the value for 
	 * ResourceProperty.
	 * 
	 * @param resourceReference The resource in Topology that owns the property.
	 */
	void setResourceReference(String resourceReference);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
