/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import java.util.logging.Logger;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.VariableFactory;
import org.w3c.dom.Document;


/**
 * The SPISession is the beginning point for working with the SPI.
 * It provides access to the various factories, as well as information and
 * functionality not tied to the representation of SDD elements.
 *
 */
public interface SPISession {

	/**
	 * A default SPISession.
	 */
	static SPISession DEFAULT_INSTANCE = SPISessionImpl.getDefaultSession();
		
	/**
	 * Creates a new BaseFactory.  
	 * 
	 * @return A new BaseFactory object
	 */
	BaseFactory createBaseFactory();
	
	/**
	 * Creates a new ContentUnitFactory.  
	 * 
	 * @return A new ContentUnitFactory object
	 */
	ContentUnitFactory createContentUnitFactory();
	
	/**
	 * Creates a new ConditionFactory.  
	 * 
	 * @return A new ConditionFactory object
	 */
	ConditionFactory createConditionFactory();
	
	/**
	 * Creates a new VariableFactory.  
	 * 
	 * @return A new VariableFactory object
	 */
	VariableFactory createVariableFactory();
	
	/**
	 * Creates a new RequirementFactory.  
	 * 
	 * @return A new RequirementFactory object
	 */
	RequirementFactory createRequirementFactory();
	
	/**
	 * Creates a new RequiredBaseFactory.  
	 * 
	 * @return A new RequiredBaseFactory object
	 */
	RequiredBaseFactory createRequiredBaseFactory();
	
	/**
	 * Creates a new ArtifactFactory.  
	 * 
	 * @return A new ArtifactFactory object
	 */
	ArtifactFactory createArtifactFactory();

	/**
	 * Creates a descriptor from a document.
	 * 
	 * @param doc A Document containing an existing Descriptor
	 * @return A PackageDescriptor or DeploymentDescriptor representing the given Document
	 * @throws InvalidInputException if the Document doesn't contain a PackageDescriptor or DeploymentDescriptor
	 */
	Descriptor buildDescriptorFromDocument(Document doc) throws InvalidInputException;
	
	/**
	 * Gets the Logger.
	 * 
	 * @return a reference to the Logger used by SPI objects 
	 */
	Logger getLogger();
}
