/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import java.util.Properties;


/**
 * Classes implementing the Translatable interface may include translatable
 * strings. 
 *
 */
public interface Translatable {
	/**
	 * Gets the key-value pairs of translatable strings.
	 * 
	 * For some object X, the returned Properties object contains the translation keys
	 * and corresponding values of translatable strings contained in X.
	 * 
	 * Details:
	 * <br>
	 * <ul>
	 *    <li>If X contains other objects which may contain translatable strings
	 *    (an Identity object containing a ManufacturerInformation
	 *    object for instance), then translatable strings in the contained object are
	 *    rolled up and included with those directly in X.</li>
	 *    <li>If there are no such strings, an empty Properties object is returned.</li>
	 *    <li>If there is a collision (multiple strings with matching keys), there will
	 *    be only one corresponding entry in the Properties object.  The value paired
	 *    with the key will be arbitrarily chosen from the colliding values.</li>  
	 * </ul>
	 * 
	 * @return a Properties object containing key-value pairs of
	 * translatable strings.
	 */
	Properties getTranslatableStrings();
}
