/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import org.w3c.dom.Element;

/**
 * The TranslatableString class consists of a pair of strings, a value and
 * a corresponding translation key.  
 * 
 *
 */
public class TranslatableString {
	private String value = null;
	private String translationKey = null;
	
	/**
	 * Creates a new TranslatableString.  
	 * 
	 * @param value The value of the TranslatableString.
	 * @param translationKey The value of the translation key.
	 */
	public TranslatableString(String value, String translationKey) {
		this.value = value;
		this.translationKey = translationKey;
	}
	
	/**
	 * Creates a new TranslatableString.  
	 * 
	 * @param displayText The element containing the display text.
	 */	
	public TranslatableString(Element displayText) {
		if (displayText != null) {
			String localValue = displayText.getTextContent();
			if (!"".equals(localValue)) {
				value = localValue;
			}
			
			String localTranslationKey = displayText.getAttribute("translationKey");
			if (!"".equals(localTranslationKey)) {
				translationKey = localTranslationKey;
			}
		}
	}
	
	/**
	 * Creates a new TranslatableString.  
	 * 
	 * @param value The value of the TranslatableString.
	 */
	public TranslatableString(String value) {
		this.value = value;
	}

	/**
	 * Gets the translation key.
	 * 
	 * @return The value of the translation key - this may be null
	 */
	public String getTranslationKey() {
		return translationKey;
	}

	/**
	 * Gets the value.
	 * 
	 * @return The value of the TranslatableString - this may be null
	 */
	public String getValue() {
		// Is this really necessary, or is "return displayText.getValue();" actually safe?
		return value;
	}

	/**
	 * Sets the value of the translation key.  If no such key is desired,
	 * pass null to this method.
	 * 
	 * @param translationKey The new value of the translation key
	 */
	public void setTranslationKey(String translationKey) {
		this.translationKey = translationKey;
	}

	/**
	 * Sets the value of the TranslatableString.  
	 * 
	 * @param value The new value of the TranslatableString
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * Returns the value of the TranslatableString.
	 * 
	 * @return The value of the TranslatableString
	 */
	public String toString() {
		return value;
	}
}
