/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactOutputVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * An ArtifactFactory is used to create objects representing or directly
 * related to artifacts.
 *
 */
public interface ArtifactFactory {
	/**
	 * Creates a new artifact.
	 * 
	 * @return A new Artifact object.
	 */
	Artifact createInstallArtifact();
	
	/**
	 * Creates a new update artifact.
	 * 
	 * @return A new Artifact object with element name "UpdateArtifact".
	 */
	Artifact createUpdateArtifact();
	
	/**
	 * Creates a new undo artifact.
	 * 
	 * @return A new Artifact object with element name "UndoArtifact".
	 */
	Artifact createUndoArtifact();
	
	/**
	 * Creates a new uninstall artifact.
	 * 
	 * @return A new Artifact object with element name "UninstallArtifact".
	 */
	Artifact createUninstallArtifact();
	
	/**
	 * Creates a new repair artifact.
	 * 
	 * @return A new Artifact object with element name "RepairArtifact".
	 */
	Artifact createRepairArtifact();
	
	/**
	 * Creates a new config artifact.
	 * 
	 * @return A new Artifact object with element name "ConfigArtifact".
	 */
	Artifact createConfigArtifact();
	
	/**
	 * Creates a new AdditionalContent.
	 * 
	 * @param contentReference A reference to the content elements id defined in the package descriptor.
	 * @return A new AdditionalContent object.
	 * @throws InvalidInputException if the parameter is null
	 */
	AdditionalContent createAdditionalContent(String contentReference);
	
	/**
	 * Creates a new StringSubstitution.
	 * 
	 * @param pattern The pattern to be matched.  This cannot be null.
	 * @param value The value to be matched.  This cannot be null.
	 * @return A new StringSubstitution object.
	 * @throws InvalidInputException if any of the parameters is null
	 */
	StringSubstitution createStringSubstitution(String pattern, String value);
	
	/**
	 * Creates a new ArtifactOutputVariable.
	 * 
	 * @param outputVariableID The output variable ID.  This cannot be null.
	 * @param artifactParameter The artifact parameter.  This cannot be null.
	 * @return A new ArtifactOutputVariable object.
	 * @throws InvalidInputException if any of the parameters is null
	 */
	ArtifactOutputVariable createArtifactOutputVariable(
			String outputVariableID, String artifactParameter);

}
