/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact;

import java.math.BigInteger;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A String substitution describes updates to be made to an {@link AdditionalContent},
 * prior to its use in the processing of the containing {@link Artifact}.  
 *
 */
public interface StringSubstitution {
	/**
	 * Gets the pattern.  
	 * 
	 * @return The pattern to be matched.
	 */	
    String getPattern();
    
    /**
	 * Gets the value.  
	 * 
	 * @return The value to be matched.
	 */	
    String getValue();
    
    /**
	 * Gets the limit.  
	 * 
	 * @return The BigInteger represents the limit.
	 */	
    BigInteger getLimit();
    
    /**
	 * Gets the required boolean.  
	 * 
	 * @return The boolean that defines if substitution is required.
	 */	
    Boolean getRequired();

    /**
     * Sets the pattern.
     * 
     * @param pattern The pattern to be matched.  This cannot be null.
     * @throws InvalidInputException if the parameter is null
     */
    void setPattern(String pattern);
    
    /**
     * Sets the value.
     * 
     * @param value The value to be matched.  This cannot be null.
     * @throws InvalidInputException if the parameter is null
     */
    void setValue(String value);

    /**
     * Sets the limit.
     * 
     * @param limit The BigInteger represents the limit.
     */
    void setLimit(BigInteger limit);
    
    /**
     * Sets the required boolean.
     * 
     * @param required The boolean that defines if substitution is required.
     */
    void setRequired(Boolean required);

    /**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
    
}
