/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;



/**
 * An ConditionFactory is used to create objects representing or directly
 * related to conditions.
 *
 */
public interface ConditionFactory {
	/**
	 * Creates a new Condition.
	 * 
	 * @return A new Condition object.
	 */
	Condition createCondition();
	
	/**
	 * Creates a new AlternativeCondition.
	 * 
	 * @param alternativeConditionID Identifier for the alternative that is unique within the deployment descriptor.
	 * @return A new AlternativeCondition object.
	 * @throws InvalidInputException if the parameter is null
	 */
	AlternativeCondition createAlternativeCondition(String alternativeConditionID);
	
	/**
	 * Creates a new ConditionalResourceConstraint.
	 * 
	 * @param constraintID Identifier for the resource constraint that is unique within the deployment descriptor.
	 * @param resourceReference The resource to which the conditions apply.
	 * @return A new ConditionalResourceConstraint object.
	 * @throws InvalidInputException if any of the parameters is null
	 */
	ConditionalResourceConstraint createConditionalResourceConstraint(String constraintID, String resourceReference);
	
	/**
	 * Creates a new multiple value conditional property constraints.
	 * 
	 * @param propertyName Name of the constrained property.
	 * @param propertyValues The collection of required property value.
	 * @return A new ConditionalPropertyConstraint object.
	 * @throws InvalidInputException if any of the parameters is null
	 */
	ConditionalPropertyConstraint createConditionalPropertyConstraintMultiValue(
			String propertyName, Collection<String> propertyValues);
	
	/**
	 * Creates a new single value conditional property constraints.
	 * 
	 * @param propertyName Name of the constrained property.
	 * @param propertyValues The required property value.
	 * @return A new ConditionalPropertyConstraint object.
	 * @throws InvalidInputException if any of the parameters is null
	 */
	ConditionalPropertyConstraint createConditionalPropertyConstraintSingleValue(
			String propertyName, String value);
	
	/**
	 * Creates a new VersionRange.
	 * 
	 * @return A new VersionRange object.
	 */
	VersionRange createVersionRange();
	
	/**
	 * Creates a new VersionValue.
	 * 
	 * @param version The version.
	 * @return A new VersionValue object.
	 * @throws InvalidInputException if any of the parameters is null.
	 */
	VersionValue createVersionValue(String version);
}
