/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

/**
 * A resource may be required during deployment of the content selected by a Feature instance. The requirement may exist 
 * because the resource is used in a Requirement statement, referred to in a Variable whose value is in scope for the particular 
 * deployment or referred to in a constraint in a Condition that is satisfied for the particular deployment. This is an in-scope, 
 * required resource for the particular deployment. The SDD author may wish to constrain in-scope, required resources to resolve 
 * to the same resource instance for all Feature instances or to resolve to unique resource instances for each Feature instance. 
 * This is done using a ConstrainedResource element.
 */
public interface ConstrainedResource {
    /**
     * Gets the resource reference.
     * 
     * The value MUST reference the id of a resource element in Topology.
     * 
     * @return A reference to the constrained resource.
     */
    String getResourceRef();
    
    /**
     * Gets the constraint type.
     * 
     * If there is a constraint, constraintType indicates that all resource instances be unique or that all resource instances 
     * be the same.<br><br> 
     * <ul>For example, all clients for a particular solution may need to connect to the same database. In this case, 
     * constraintType would be set to same. In other cases, each of the deployed resources might need to use its own unique 
     * instance of a required resource. If there could be only one client per operating system, a constraint on the operating 
     * system resource would set constraintType to unique.</ul>
     * 
     * @return A String that indicates whether the constraint requires every instance of the resource to be the same or requires every instance 
     * to be different.
     */
    String getConstraintType();
    
    /**
     * Sets the resource reference.
     * 
     * The value MUST reference the id of a resource element in Topology.
     * 
     * @param resourceRef A reference to the constrained resource.
     */
    void setResourceRef(String resourceRef);
    
    /**
     * Sets the constraint type.
     * 
     * If there is a constraint, constraintType indicates that all resource instances be unique or that all resource instances 
     * be the same.<br><br> 
     * <ul>For example, all clients for a particular solution may need to connect to the same database. In this case, 
     * constraintType would be set to same. In other cases, each of the deployed resources might need to use its own unique 
     * instance of a required resource. If there could be only one client per operating system, a constraint on the operating 
     * system resource would set constraintType to unique.</ul>
     * 
     * @param type A string that indicates whether the constraint requires every instance of the resource to be the same or requires every instance 
     * to be different.
     */
    void setConstraintType(String type);
    
	/**
	 * Create a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
