/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * The ContentSelectionFeatureType allows for the definition of the number of times a feature can be referenced if that 
 * feature includes a Multiplicity element.
 * 
 * For example, a software package has a server and client; the server can be deployed only on one machine, but the client 
 * can be deployed on multiple machines and configured to reference the one server. The server, for performance reasons, is limited 
 * to 10 client connections. To limit the number of times the client can be deployed, the selections attribute should be set to 10.</ul> 
 */
public interface ContentSelectionFeature {
    /**
     * Gets the selections.
     * 
     * The value of selections MUST be, or resolve to, a positive integer that is within the bounds of the minSelections and 
     * maxSelections attributes defined in the Multiplicity element of the referenced feature.
     * 
     * @return The number of times a feature with Multiplicity in the referenced package should be deployed.
     */
    String getSelections();
    
    /**
     * Gets the feature.
     * 
     * Features can be used to organize optional functionality into meaningful selections. Features should be meaningful from 
     * the deployers point of view.
     * 
     * @return A definition of user-selectable content.
     */
    String getFeature();
    
    /**
     * Sets the selections.
     * 
     * The value of selections MUST be, or resolve to, a positive integer that is within the bounds of the minSelections and 
     * maxSelections attributes defined in the Multiplicity element of the referenced feature.
     * 
     * @param selections The number of times a feature with Multiplicity in the referenced package should be deployed.
     */
    void setSelections(String selections);
    
    /**
     * Sets the feature.
     * 
     * Features can be used to organize optional functionality into meaningful selections. Features should be meaningful from the deployers 
     * point of view.
     * @param feature A definition of user-selectable content.
     * @throws InvalidInputException if the parameter is null
     */
    void setFeature(String feature);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
