/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * GroupType provides the type definition for each Group element in SelectableContents list of Groups. For a particular 
 * deployment, zero or one groups may be selected by the deployer.
 */
public interface Group extends DisplayNameable {
    
    /**
     * Gets the selected features.
     * 
     * Each SelectedFeature is considered selected if inputs identify the group as selected.<br><br>
     * Selection of a nested feature causes its parent feature to be selected.
     *  
     * @return Features that are part of the group.
     */
    Collection<String> getSelectedFeatures();
    
    /**
     * Gets the group ID.
     * 
     * The groups id may be used to refer to the group when aggregating the SDD into another SDD.
     * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
     * 
     * @return An identifier of the group that is unique within the descriptor.
     */
    String getGroupID();
    
    /**
     * Gets whether this is the default group.
     * 
     * Multiple default Groups MUST NOT be defined.
     * 
     * @return A boolean indicates that the group is selected by default when no selections are provided by the deployer.
     */
    Boolean getDefault();

    /**
     * Sets the selected feature.
     * 
     * This method will take the collection of selected features, create the FeatureReference DataObjects,
     * and set the featureRef attribute in each DataObject. If people need to extend the FeatureReference
     * DataObject in the future, this may have to be broken out into a separate class.
     *  
     * @param A collection of feature IDs
     * @throws InvalidInputException if the parameter is null
     */
    void setSelectedFeatures(Collection<String> refs);
    
    /**
     * Sets the group ID.
     * 
     * The groups id may be used to refer to the group when aggregating the SDD into another SDD.
     * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
     * 
     * @param id An identifier of the group that is unique within the descriptor.
     * @throws InvalidInputException if the parameter is null
     */
    void setGroupID(String id);
    
    /**
     * Sets whether this is the default group.
     * 
     * Multiple default Groups MUST NOT be defined.
     * 
     * @param value A boolean indicates that the group is selected by default when no selections are provided by the deployer.
     */
    void setDefault(Boolean value);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
