/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * LanguageType supports the definition of display information and the language code for one language. It is used 
 * everywhere a language is defined in the SDD.
 */
public interface Language extends DisplayNameable {
    /**
     * Gets the type of the language.
     * 
     * The type attribute MUST be defined as a value that conforms to the set of language codes defined by [RFC3066].
     * <ul>For example, de is a locale code for German and en-US is the locale code for English in the United States.</ul>
     * 
     * @return The locale code for the language.
     */
    String getType();
    
    /**
     * Sets the type of the language.
     * 
     * The type attribute MUST be defined as a value that conforms to the set of language codes defined by [RFC3066].
     * <ul>For example, de is a locale code for German and en-US is the locale code for English in the United States.</ul>
     * 
     * @param type The locale code for the language.
     * @throws InvalidInputException if the parameter is null
     */
    void setType(String type);

	/**
	 * Creates a copy of the object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
