/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;

/**
 *  The LocalizationUnit element defines artifacts that deploy localization content for one group of resources whose translations
 *  are packaged together. Localization content consists of materials that have been translated into one or more languages. 
 *
 */
public interface LocalizationUnit extends InstallUnit {
	
    /**
     * Gets the localization base.
     * 
     * LocalizationBase identifies the resource or resources that can be localized by processing the LocalizationUnit. A 
     * resource that satisfies the constraints defined in the LocalizationBase is one that can be localized by applying the 
     * LocalizationUnit.<br><br>
     * If no resource is found that meets the constraints defined in LocalizationBase during a particular deployment, 
     * then the LocalizationUnit is not considered to be in scope for that deployment. This does not represent an error.<br><br>
     * Translations created or modified by the LocalizationUnit are for human-readable text included with the LocalizationBase 
     * resources.
     *  
     * @return A resource whose translatable characteristics will be localized by processing the LocalizationUnits InstallArtifact.
     */
    RequiredBase getLocalizationBase();
    
    
    /**
     * Gets the completion actions.
     * 
     * A Completion element MUST be included if the artifact being processed requires a system operation such as a reboot 
     * or logoff to occur to function successfully after deployment or if the artifact executes a system operation to complete 
     * deployment of the contents of the artifact.<br><br>
     * There MUST be an artifact associated with the operation defined by a Completion element.<br><br>
     * <ul>For example, if there is a Completion element for the install operation, the LocalizationUnit must define an 
     * InstallArtifact.</ul>
     *  
     * @return A collection of Completion objects that describe completion actions such as restart and the conditions under which the action is applied.
     */
    Collection<Completion> getCompletion();
    
    /**
     * Sets the localization base.
     * 
     * LocalizationBase identifies the resource or resources that can be localized by processing the LocalizationUnit. A 
     * resource that satisfies the constraints defined in the LocalizationBase is one that can be localized by applying the 
     * LocalizationUnit.<br><br>
     * If no resource is found that meets the constraints defined in LocalizationBase during a particular deployment, 
     * then the LocalizationUnit is not considered to be in scope for that deployment. This does not represent an error.<br><br>
     * Translations created or modified by the LocalizationUnit are for human-readable text included with the LocalizationBase 
     * resources.
     * 
     * @param localizationBase A resource whose translatable characteristics will be localized by processing the 
     * LocalizationUnits InstallArtifact.
     * @throws InvalidInputException if the parameter is null
     */
    void setLocalizationBase(RequiredBase localizationBase);
    
    /**
     * Sets the completion actions.
     * 
     * A Completion element MUST be included if the artifact being processed requires a system operation such as a reboot 
     * or logoff to occur to function successfully after deployment or if the artifact executes a system operation to complete 
     * deployment of the contents of the artifact.<br><br>
     * There MUST be an artifact associated with the operation defined by a Completion element.<br><br>
     * <ul>For example, if there is a Completion element for the install operation, the LocalizationUnit must define an 
     * InstallArtifact.</ul>
     * 
     * @param configurationUnitCompletion A collection of Completion objects that describes completion actions such as restart and the conditions under 
     * which the action is applied.
     */
    void setCompletion(Collection<Completion> configurationUnitCompletion);
}
