/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * PackageFeatureReferenceType provides a way to reference a feature defined in a referenced SDD. It identifies the 
 * ContainedPackage element that references the SDD and the feature in the referenced SDD.
 *
 */
public interface PackageFeatureReference {
	
    /**
     * Gets the content element reference.
     * 
     * This value MUST reference the id of a ContainedPackage element in SelectableContent or BaseContent. This reference 
     * does not cause the ContainedPackage to be in scope.
     * 
     * @return Reference to a content element in the deployment descriptor.
     */
    String getContentElementRef();
    
    /**
     * Gets the package feature reference.
     * 
     * Specifies the value of the id of a feature element from the SDD of the ContainedPackage identified in contentElementRef. 
     * This feature reference is ignored when the ContainedPackage identified in contentElementRef is not in scope for a 
     * particular deployment.
     * 
     * @return The features id as defined in the referenced packages deployment descriptor.
     */
    String getPackageFeatureRef();
    
    /**
     * Sets the content element reference.
     * 
     * This value MUST reference the id of a ContainedPackage element in SelectableContent or BaseContent. This reference 
     * does not cause the ContainedPackage to be in scope.
     * 
     * @param contentElementRef Reference to a content element in the deployment descriptor.
     * @throws InvalidInputException if the parameter is null
     */
    void setContentElementRef(String contentElementRef);
    
    /**
     * Sets the package feature reference.
     * 
     * Specifies the value of the id of a feature element from the SDD of the ContainedPackage identified in contentElementRef. 
     * This feature reference is ignored when the ContainedPackage identified in contentElementRef is not in scope for a 
     * particular deployment.
     * 
     * @param packageFeatureRef The features id as defined in the referenced packages deployment descriptor.
     * @throws InvalidInputException if the parameter is null
     */
    void setPackageFeatureRef(String packageFeatureRef);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
