/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * The RelationshipType describes the relationship between two resources.
 *
 */
public interface Relationship {
	
    /**
     * Gets the properties.
     * 
     * This element MAY be used to provide additional information about the relationship. 
     * <ul>For example, a connectivity relationship might specify additional information such as the specific protocol 
     * used (for instance, TCP/IP) and/or particular characteristics of a protocol (for instance, port number).</ul>
     * 
     * @return A property definition that further constrains the relationship.
     */
    Properties getProperties();
    
    /**
     * Gets the related resources reference.
     * 
     * There are two resources in any relationship. The first is the resource defined in the resourceRef of the ResultingResource 
     * or RelationshipConstraint element that defines the Relationship element. The second resource is the one identified by 
     * relatedResourceRef.<br><br>
     * The value MUST reference the id of a resource specified in Topology.
     * 
     * @return The second resource in the relationship.
     */
    String getRelatedResourceReference();
    
    /**
     * Gets the relationship type.
     * 
     * Values for relationship type are not defined by the SDD specification. This type may be specified in profiles 
     * 
     * @return The type of the relationship.
     */
    String getType();
    
    /**
     * Sets the properties.
     * 
     * This element MAY be used to provide additional information about the relationship. 
     * <ul>For example, a connectivity relationship might specify additional information such as the specific protocol 
     * used (for instance, TCP/IP) and/or particular characteristics of a protocol (for instance, port number).</ul>
     * 
     * @param props A property definition that further constrains the relationship.
     */
    void setProperties(Properties props);
    
    
    /**
     * Sets the related resource reference.
     * 
     * There are two resources in any relationship. The first is the resource defined in the resourceRef of the ResultingResource 
     * or RelationshipConstraint element that defines the Relationship element. The second resource is the one identified by 
     * relatedResourceRef.<br><br>
     * The value MUST reference the id of a resource specified in Topology.
     * 
     * @param ref The second resource in the relationship.
     * @throws InvalidInputException if the parameter is null
     */
    void setRelatedResourceReference(String ref);
    
    /**
     * Sets the relationship type.
     * 
     * Values for relationship type are not defined by the SDD specification. This type may be specified in profiles 
     * 
     * @param type The type of the relationship.
     * @throws InvalidInputException if the parameter is null
     */
    void setType(String type);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    public Object clone();
}
