/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception;

/**
 * 
 * The exception may be thrown on any method for which a invalid input was passed in.
 *
 */
public class InvalidInputException extends IllegalArgumentException {
	public static final int NULL_ARGUMENT = 0;
	public static final int NULL_ARRAY_ELEMENT = 1;
	public static final int EMPTY_ARRAY = 2;
	public static final int STRING_PATTERN_MISMATCH = 3;
	public static final int INVALID_VALUE = 4;
	public static final int REMOVING_REQUIRED_CONTENT = 5;
	public static final int EMPTY_LIST = 6;
	
	private String[] reasonNames = {
			"NULL_ARGUMENT", "NULL_ARRAY_ELEMENT",
			"EMPTY_ARRAY","STRING_PATTERN_MISMATCH", "INVALID_VALUE",
			"REMOVING_REQUIRED_CONTENT", "EMPTY_LIST"};
		
	private int argumentNumber;
	private int reason;
	
	/**
	 * Creates the InvalidInputException.
	 * 
	 * @param argumentNumber Argument number.
	 * @param reason Why it is invalid.
	 */
	public InvalidInputException(int argumentNumber, int reason)
	{
		super();
		this.argumentNumber = argumentNumber;
		this.reason = reason;
	}
	
	/**
	 * Gets the argument number.
	 * 
	 * @return The argument number.
	 */
	public int getArgumentNumber()
	{
		return argumentNumber;
	}
	
	/**
	 * Returns why the input is invalid.
	 * 
	 * @return Why the input is invalid.
	 */
	public int getReason()
	{
		return reason;
	}
	
	/**
	 * Returns a string with argument number and the reason.
	 * 
	 * @return A string with argument number and the reason.
	 */
	public String toString()
	{
		return "Arg " + argumentNumber + "  - " + reasonNames[reason];
	}
}
