/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A UniquenessConstraint is used to indicate when two resources defined in topology MUST or MUST NOT resolve to the same resource 
 * instance during a particular deployment. A UniquenessConstraint indicates that the two resources MUST NOT be the same when it is 
 * defined in a ResourceConstraint element with testValue=true. A UniquenessConstraint indicates that the two resources MUST be the 
 * same when defined in a ResourceConstraint with testValue=false.<br><br>
 * When no UniquenessConstraint is in scope for a particular pair of resources, the two resources MAY resolve to the same resource when
 * their identifying characteristics are the same and when all in-scope constraints on both resources are satisfied.<br><br>
 * The first of the pair of resources is identified in the resourceRef attribute of the ResourceConstraint element that defines the 
 * UniquenessConstraint. The second of the pair is identified in the distinctResourceRef attribute of the UniquenessConstraint.
 */
public interface UniquenessConstraint extends Describable {
    /**
     * Gets the distinct resource reference.
     * 
     * The second resource in the pair of resources.<br><br>
     * The value MUST reference the id of a resource element in Topology.
     * 
     * @return One of the pair of resources referred to by the constraint.
     */
    String getDistinctResourceReference();
    
    /**
     * Sets the distinct resource reference.
     * 
     * The second resource in the pair of resources.<br><br>
     * The value MUST reference the id of a resource element in Topology.
     * 
     * @param ref One of the pair of resources referred to by the constraint.
     * @throws InvalidInputException if the parameter is null
     */
    void setDistinctResourceReference(String ref);
    
	/**
	 * Create a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
