/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;

/**
 * A version constraint can be specified using any number of individual version values in combination with any number of version ranges. 
 */
public interface VersionConstraintValue {
	/**
	 * Gets the values.
	 * 
	 * Discrete version values can be defined when the set of required versions includes versions that do not fall within a range. 
	 * There is no assumption by this specification that version values are numerically comparable. The method of comparing version 
	 * values may be resource-specific. 
	 * 
	 * @return A collection of version values with associated fixes specified.
	 */
	Collection<VersionValue> getValues();
	
	/**
	 * Gets the ranges.
	 * 
	 * A VersionRange is specified with a minimum and maximum version value and a list of required fixes associated with that range. 
	 * The method of comparing version strings in a version range is resource-specific.
	 * 
	 * @return A collection of ranges of version values with associated fixes specified for each range.
	 */
	Collection<VersionRange> getRanges();
	
	/**
	 * Sets the values.
	 * 
	 * Discrete version values can be defined when the set of required versions includes versions that do not fall within a range. 
	 * There is no assumption by this specification that version values are numerically comparable. The method of comparing version 
	 * values may be resource-specific. 
	 * 
	 * @param value A collection of version values with associated fixes specified.
	 */
	void setValue(Collection<VersionValue> value);
	
	/**
	 * Sets the ranges.
	 * 
	 * A VersionRange is specified with a minimum and maximum version value and a list of required fixes associated with that range. 
	 * The method of comparing version strings in a version range is resource-specific.
	 * 
	 * @param range A collection of ranges of version values with associated fixes specified for each range.
	 */
	void setRange(Collection<VersionRange> range);	  
}