/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A DerivedVariable defines a single expression. The value of the variable is determined by setting the variable to the result of 
 * the expression whose condition evaluated to true. This restriction does not apply to variables of the same name in different 
 * descriptors. The SDD author MUST create DerivedVariables in a way that makes the selection of the expression unambiguous.<br><br>
 * 
 * Related class {@link ConditionalDerivedVariable}   
 */
public interface DerivedVariable extends BaseVariable {
	/**
	 * Gets the expression.
	 * 
	 * When the DerivedVariable is used to define one variable whose value is not conditional, the SDD author can include one 
	 * variable expression defined in one Expression element.
	 * 
	 * @return An expression whose results become the value of the variable.
	 */
	String getExpression();
	
	/**
	 * Sets the expression.
	 * 
	 * When the DerivedVariable is used to define one variable whose value is not conditional, the SDD author can include one 
	 * variable expression defined in one Expression element.
	 * 
	 * @param expression An expression whose results become the value of the variable.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setExpression(String expression);
	
	/**
	 * Creates a coyp of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
