/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * IntegerParameterType defines upper and lower bounds that can be used to validate the input received for that parameter.
 */
public interface IntegerParameter extends Parameter {
    /**
     * Gets the bounds.
     * 
     * If there are restrictions on the range of values that are valid for a parameter, those restrictions MUST be specified in Bounds.
     * 
     * @return A collection of ParameterBoundary objects that specify the boundaries for the value of the parameter.
     */
    Collection<ParameterBoundary> getBounds();
    
    /**
     * Sets the bounds.
     * 
     * If there are restrictions on the range of values that are valid for a parameter, those restrictions MUST be specified in Bounds.
     * 
     * @param bounds A collection of ParameterBoundary objects that specify the boundaries for the value of the parameter.
     * @throws InvalidInputException if the parameter is null
     */
    void setBounds(Collection<ParameterBoundary> bounds);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
