/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

/**
 * Output variables are variables whose value is set by artifact processing. OutputVariableType extends BaseVariableType and so 
 * has all of the attributes defined there, including an id attribute that is used to refer to the output variable within the SDD. 
 * Output variables can be useful in log and trace messages. 
 */
public interface OutputVariable extends BaseVariable {
    /**
     * Gets the output parameter name.
     * 
     * This is the name of the output variable as understood within the artifact processing environment. The output value is 
     * associated with the output variables id. The SDD author uses this id within the SDD to refer to this output value.
     * 
     * @return An output from artifact processing.
     */
    String getOutputParameterName();
    
    /**
     * Sets the output parameter name.
     * 
     * This is the name of the output variable as understood within the artifact processing environment. The output value is 
     * associated with the output variables id. The SDD author uses this id within the SDD to refer to this output value.
     * 
     * @param outputParameterName An output from artifact processing.
     */
    void setOutputParameterName(String outputParameterName);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    public Object clone();
}
