/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

import java.math.BigInteger;
import java.util.Collection;

/**
 * StringParameterType supports definition of minimum and maximum lengths that can be used to validate the input received 
 * for the string parameter. It also supports definition of a list of valid input values.
 */
public interface StringParameter extends Parameter {
    /**
     * Gets the minimum length.
     * 
     * When no minimum length is specified, no string is too short, including an empty string.
     * 
     * @return Minimum length of the parameter value.
     */
    BigInteger getMinLength();
    
    /**
     * Gets the maximum length.
     * 
     * When no maximum length is specified, no string is too long.
     * 
     * @return Maximum length of the parameter value.
     */
    BigInteger getMaxLength();

    /**
     * Gets the valid values.
     * 
     * Any number of valid values for the parameter can be listed using ValidValue elements.<br><br>
     * When both defaultValue and one or more ValidValues are specified, defaultValue MUST match one of the ValidValues.<br><br>
     * ValidValues should be in the correct case as identified in the case attribute.
     * 
     * @return A collection of strings each representing a valid value for the parameter.
     */
    Collection<String> getValidValues();
    
    /**
     * Gets the case of the string.
     * 
     * Used when the case of the string is restricted. Defaults to mixed if not defined.
     * 
     * @return The case of the stringupper, lower or mixed.
     */
    String getCase();
    
    /**
     * Sets the minimum length.
     * 
     * When no minimum length is specified, no string is too short, including an empty string.
     * 
     * @param minLength Minimum length of the parameter value.
     */
    void setMinLength(BigInteger minLength);
    
    /**
     * Sets the maximum length.
     * 
     * When no maximum length is specified, no string is too long.
     * 
     * @param maxLength Maximum length of the parameter value.
     */
    void setMaxLength(BigInteger maxLength);

    /**
     * Sets the valid values.
     * 
     * Any number of valid values for the parameter can be listed using ValidValue elements.<br><br>
     * When both defaultValue and one or more ValidValues are specified, defaultValue MUST match one of the ValidValues.<br><br>
     * ValidValues should be in the correct case as identified in the case attribute.
     * 
     * @param validValues A collection of strings each representing one valid value for the parameter.
     */
    void setValidValues(Collection<String> validValues);
    
    /**
     * Sets the case of the string.
     * 
     * Used when the case of the string is restricted. Defaults to mixed if not defined.
     * 
     * @param caseValue The case of the stringupper, lower or mixed.
     * <ul>**default value=mixed</ul>
     */
    void setCase(String caseValue);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
