/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * KeyInfo is an optional element that enables the recipient(s) to obtain the key 
 * needed to validate the signature.  
 * 
 * KeyInfo may contain keys, names, certificates and other public key management information, 
 * such as in-band key distribution or key agreement data.
 *
 */
public interface KeyInfo {
	/**
	 * Gets the key name.
	 * 
	 * @return The key name.
	 */
	String getKeyName();
	
	/**
	 * Sets the key name.
	 * 
	 * @param keyName The new key name.
	 */
	void setKeyName(String keyName);
	
	/** 
	 * Gets the key value.
	 * 
	 * @return The key value.
	 */
	KeyValue getKeyValue();
	
	/**
	 * Sets the key value.
	 * 
	 * @param keyValue The new key value.
	 */
	void setKeyValue(KeyValue keyValue);
	
	/**
	 * Gets the retrieval method.
	 * 
	 * A RetrievalMethod element within KeyInfo is used to convey a reference to KeyInfo 
	 * information that is stored at another location. For example, several signatures in a 
	 * document might use a key verified by an X.509v3 certificate chain appearing once in the 
	 * document or remotely outside the document; each signature's KeyInfo can reference this 
	 * chain using a single RetrievalMethod element instead of including the entire chain with 
	 * a sequence of X509Certificate  elements.
	 * 
	 * @return The RetrievalMethod.
	 */
	RetrievalMethod getRetrievalMethod();
	
	/**
	 * Sets the retrieval method.
	 * 
	 * A RetrievalMethod element within KeyInfo is used to convey a reference to KeyInfo 
	 * information that is stored at another location. For example, several signatures in a 
	 * document might use a key verified by an X.509v3 certificate chain appearing once in the 
	 * document or remotely outside the document; each signature's KeyInfo can reference this 
	 * chain using a single RetrievalMethod element instead of including the entire chain with 
	 * a sequence of X509Certificate  elements.
	 * 
	 * @param retrievalMethod The new RetrievalMethod.
	 */
	void setRetrievalMethod(RetrievalMethod retrievalMethod);
	
	/**
	 * Gets the X509Data.
	 * 
	 * An X509Data element within KeyInfo  contains one or more identifiers of keys or X509 
	 * certificates (or certificates' identifiers or a revocation list). 
	 * 
	 * @return X509Data.
	 */
	X509Data getX509Data();
	
	/**
	 * Sets the X509Data.
	 * 
	 * An X509Data element within KeyInfo  contains one or more identifiers of keys or X509 
	 * certificates (or certificates' identifiers or a revocation list). 
	 * 
	 * @param x509Data The new X509Data.
	 */
	void setX509Data(X509Data x509Data);
	
	/**
	 * Gets the PGPData.
	 * 
	 * The PGPData element within KeyInfo  is used to convey information related to PGP 
	 * public key pairs and signatures on such keys. 
	 * 
	 * @return PGPData.
	 */
	PGPData getPGPData();
	
	/**
	 * Sets the PGPData.
	 * 
	 * The PGPData element within KeyInfo  is used to convey information related to PGP 
	 * public key pairs and signatures on such keys. 
	 * 
	 * @param pgpData The new PGPData.
	 */
	void setPGPData(PGPData pgpData);
	
	/**
	 * Gets the SPKIData.
	 * 
	 * The SPKIData element within KeyInfo  is used to convey information related to SPKI 
	 * public key pairs, certificates and other SPKI data. 
	 * 
	 * @return SPKIData.
	 */
	SPKIData getSPKIData();
	
	/**
	 * Sets the SPKIData.
	 * 
	 * The SPKIData element within KeyInfo  is used to convey information related to SPKI 
	 * public key pairs, certificates and other SPKI data. 
	 * 
	 * @param spkiData The new SPKIData.
	 */
	void setSPKIData(SPKIData spkiData);
	
	/**
	 * Gets the MgmtData.
	 * 
	 * The MgmtData element within KeyInfo is a string value used to convey in-band key 
	 * distribution or agreement data.
	 * 
	 * @return MgmtData.
	 */
	String getMgmtData();
	
	/**
	 * Sets the MgmtData.
	 * 
	 * The MgmtData element within KeyInfo is a string value used to convey in-band key 
	 * distribution or agreement data.
	 * 
	 * @param mgmtData The new MgmtData.
	 */
	void setMgmtData(String mgmtData);
	
	/**
	 * Gets the ID.
	 * 
	 * @return ID.
	 */
	String getId();
	
	/**
	 * Sets the ID.
	 * 
	 * @param id The new ID.
	 */
	void setId(String id);
}
