/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * The PGPData element within KeyInfo is used to convey information related to PGP 
 * public key pairs and signatures on such keys. 
 * 
 * The PGPKeyID's value is a base64Binary sequence containing a standard PGP public key 
 * identifier as defined in [PGP, section 11.2]. 
 * The PGPKeyPacket  contains a base64-encoded Key Material Packet as defined in [PGP, section 5.5]. 
 * These children element types can be complemented/extended by siblings from an external 
 * namespace within PGPData, or PGPData can be replaced all together with an alternative PGP XML 
 * structure as a child of KeyInfo. PGPData must contain one PGPKeyID  and/or one PGPKeyPacket and 
 * 0 or more elements from an external namespace.
 * 
 * 
 *
 */
public interface PGPData {
	/**
	 * Gets the PGPKeyID.
	 * 
	 * @return Value of PGPKeyID.
	 */
	byte[] getPGPKeyID();
	
	/**
	 * Gets the PGPKeyID.
	 * 
	 * @param pgpKeyID New value of PGPKeyID.
	 */
	void setPGPKeyID(byte[] pgpKeyID);
	
	/**
	 * Gets the PGPKeyPacket.
	 * 
	 * @return Value of PGPKeyPacket.
	 */
	byte[] getPGPKeyPacket();
	
	/**
	 * Sets the PGPKeyPacket.
	 * 
	 * @param pgpKeyPacket New value of PGPKeyPacket.
	 */
	void setPGPKeyPacket(byte[] pgpKeyPacket);
}
