/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * RSAKeyValue can be used within a RetrievalMethod or Reference element to identify 
 * the referent's type. 
 * 
 * RSA key values have two fields: Modulus and Exponent.
 * 
 */
public interface RSAKeyValue {
	/**
	 * Gets the modulus.
	 * 
	 * @return The modulus value.
	 */
	byte[] getModulus();
	
	/**
	 * Sets the modulus.
	 * 
	 * @param modulus The new modulus value.
	 */
	void setModulus(byte[] modulus);
	
	/**
	 * Gets the exponent.
	 * 
	 * @return The exponent value.
	 */
	byte[] getExponent();
	
	/**
	 * Sets the exponent.
	 * 
	 * @param exponent The new exponent value.
	 */
	void setExponent(byte[] exponent);
}
