/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

import java.util.Collection;

/**
 * Reference is an element that may occur one or more times. It specifies a digest algorithm 
 * and digest value, and optionally an identifier of the object being signed, the type of the 
 * object, and/or a list of transforms to be applied prior to digesting. The identification (URI) 
 * and transforms describe how the digested content (i.e., the input to the digest method) was 
 * created. The Type attribute facilitates the processing of referenced data. For example, while 
 * this specification makes no requirements over external data, an application may wish to signal 
 * that the referent is a Manifest. An optional ID attribute permits a Reference to be referenced 
 * from elsewhere.
 * 
 *
 */
public interface Reference extends Digest {
	/**
	 * Gets the transforms.
	 * 
	 * @return A collection of Transform objects.
	 */
	Collection<Transform> getTransforms();
	
	/**
	 * Sets the transforms.
	 * 
	 * @param transforms A collection of Transform objects.
	 */
	void setTransforms(Collection<Transform> transforms);
	
	/**
	 * Gets the ID.
	 * 
	 * @return The ID.
	 */
	String getId();
	
	/**
	 * Sets the ID.
	 * 
	 * @param id The new ID.
	 */
	void setId(String id);
	
	/**
	 * Gets the URI.
	 * 
	 * @return URI string.
	 */
	String getURI();
	
	/**
	 * Sets the URI.
	 * 
	 * @param uri The new URI string.
	 */
	void setURI(String uri);
	
	/**
	 * Gets the type.
	 * 
	 * @return The type.
	 */
	String getType();
	
	/**
	 * Sets the type.
	 * 
	 * @param type The new type.
	 */
	void setType(String type);
}
