/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

import java.util.Collection;

/**
 * 
 * A RetrievalMethod element within KeyInfo is used to convey a reference to KeyInfo information 
 * that is stored at another location. For example, several signatures in a document might use a 
 * key verified by an X.509v3 certificate chain appearing once in the document or remotely outside 
 * the document; each signature's KeyInfo can reference this chain using a single RetrievalMethod 
 * element instead of including the entire chain with a sequence of X509Certificate elements.
 *
 */
public interface RetrievalMethod {
	/**
	 * Gets the transforms.
	 * 
	 * @return A collection of Transform objects.
	 */
	Collection<Transform> getTransforms();
	
	/**
	 * Sets the transforms
	 * 
	 * @param transforms A collection of transform objects.
	 */
	void setTransforms(Collection<Transform> transforms);

	/**
	 * Get the URI.
	 * 
	 * @return URI value.
	 */
	String getURI();
	
	/**
	 * Sets the URI.
	 * 
	 * @param uri A new URI value.
	 */
	void setURI(String uri);
	
	/**
	 * Gets the type.
	 * 
	 * @return The type.
	 */
	String getType();
	
	/**
	 * Sets the type.
	 * 
	 * @param type A new type.
	 */
	void setType(String type);
}
