/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * An X509Data element within KeyInfo contains one or more identifiers of keys or X509 
 * certificates (or certificates' identifiers or a revocation list). 
 * 
 * The content of X509Data is:
 *    At least one element, from the following set of element types; any of these may appear 
 *    together or more than once iff (if and only if) each instance describes or is related to 
 *    the same certificate:
 * 			The X509IssuerSerial element, which contains an X.509 issuer distinguished name/serial number pair. 
 * 			The X509SubjectName element, which contains an X.509 subject distinguished name that SHOULD be 
 * 				represented as a string that complies with section 3 of RFC4514 [LDAP-DN], to be generated 
 * 				according to the Distinguished Name Encoding Rules. 
 * 			The X509SKI element, which contains the base64 encoded plain (i.e. non-DER-encoded) value of a 
 * 				X509 V.3 SubjectKeyIdentifier extension.
 * 			The X509Certificate element, which contains a base64-encoded [X509v3] certificate.
 * 			Elements from an external namespace which accompanies/complements any of the elements above.
 * 			The X509CRL element, which contains a base64-encoded certificate revocation list (CRL) [X509v3].
 *
 * Any X509IssuerSerial, X509SKI, and X509SubjectName elements that appear MUST refer to the certificate or 
 * certificates containing the validation key. All such elements that refer to a particular individual certificate 
 * MUST be grouped inside a single X509Data  element and if the certificate to which they refer appears, it MUST 
 * also be in that X509Data element.
 * 
 * Any X509IssuerSerial, X509SKI, and X509SubjectName elements that relate to the same key but different certificates 
 * MUST be grouped within a single KeyInfo but MAY occur in multiple X509Data elements.
 * 
 * All certificates appearing in an X509Data element MUST relate to the validation key by either containing it or 
 * being part of a certification chain that terminates in a certificate containing the validation key.
 */
public interface X509Data {
	/**
	 * Gets X509 issuer name.
	 * 
	 * @return X509 issuer name.
	 */
	String getX509IssuerName();
	
	/**
	 * Sets the X509 issuer name.
	 * 
	 * @param x509IssuerName A new X509 issuer name.
	 */
	void setX509IssuerName(String x509IssuerName);
	
	/**
	 * Gets X509 serial number.
	 * 
	 * @return X509 serial number.
	 */
	Integer getX509SerialNumber();
	
	/**
	 * Sets X509 serial number.
	 * 
	 * @param x509SerialNumber A new X509 serial number.
	 */
	void setX509SerialNumber(Integer x509SerialNumber);
	
	/**
	 * Gets the value of X509SKI.
	 * 
	 * @return The value of X509SKI.
	 */
	byte[] getX509SKI();
	
	/**
	 * Sets the value of X509SKI.
	 * 
	 * @param x509SKI A new value for X509SKI.
	 */
	void setX509SKI(byte[] x509SKI);
	
	/**
	 * Gets the X509 subject name.
	 * 
	 * @return The X509 subject name.
	 */
	String getX509SubjectName();
	
	/**
	 * Sets the X509 subject name.
	 * 
	 * @param x509SubjectName A new X509 subject name.
	 */
	void setX509SubjectName(String x509SubjectName);
	
	/**
	 * Gets the X509 certificate.
	 * 
	 * @return A base64-encoded certificate.
	 */
	byte[] getX509Certificate();
	
	/**
	 * Sets the X509 certificate.
	 * 
	 * @param x509Certificate A new base64-encoded certificate.
	 */
	void setX509Certificate(byte[] x509Certificate);
	
	/**
	 * Gets the value of X509CRL.
	 * 
	 * @return A base64-encoded certificate revocation list (CRL).
	 */
	byte[] getX509CRL();
	
	/**
	 * Sets the value of X509CRL.
	 * 
	 * @param x509CRL A new base64-encoded certificate revocation list (CRL).
	 */
	void setX509CRL(byte[] x509CRL);
}