/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dr.internal.web.ui;

import org.eclipse.cosmos.dr.internal.web.ui.Messages;
import org.eclipse.cosmos.dr.internal.web.ui.WebViewerActivator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WebUIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text port;
    private Text host;

    public WebUIPreferencePage() {
    }

    public WebUIPreferencePage(String title) {
        super(title);
    }

    public WebUIPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)data);
        layout.numColumns = 1;
        Group group = new Group(topComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString("COSMOSPreferencePage.0"));
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("COSMOSPreferencePage.1"));
        this.host = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.host.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("COSMOSPreferencePage.2"));
        this.port = new Text((Composite)group, 2048);
        this.port.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 60;
        this.port.setLayoutData((Object)gridData);
        this.host.setText(WebViewerActivator.getDefault().getHostPreference());
        this.port.setText(WebViewerActivator.getDefault().getPortPreference());
        Dialog.applyDialogFont((Control)topComposite);
        return topComposite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebViewerActivator.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.host.setText(WebViewerActivator.getDefault().getDefaultHostPreference());
        this.port.setText(WebViewerActivator.getDefault().getDefaultPortPreference());
        this.setErrorMessage(null);
        this.setValid(true);
    }

    public boolean performOk() {
        this.validateAndUpdate();
        return this.isValid();
    }

    private void validateAndUpdate() {
        this.validateData();
        this.updateDefaults();
    }

    private void updateDefaults() {
        WebViewerActivator.getDefault().setHostPreference(this.host.getText());
        WebViewerActivator.getDefault().setPortPreference(this.port.getText());
    }

    private void validateData() {
        if ("".equals(this.host.getText().trim()) || "".equals(this.port.getText().trim())) {
            this.setErrorMessage(Messages.getString("COSMOSPreferencePage.5"));
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }
}

