/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

 public class LoggerWrapper {

    private ILogger log;

    private static LoggerWrapper logwrapper;

    public ILogger createLogger(Class clazz){
    	return new SimpleLogger();
    }
    public ILogger createLogger(String name){
    	return new SimpleLogger();
    }

    public static ILogger getLogger(Class clazz) {
    	if (logwrapper == null){
    		logwrapper = new LoggerWrapper();
    	}
   		return logwrapper.createLogger(clazz);
    }

    public static LoggerWrapper getLogwrapper() {
		return logwrapper;
	}
	public static void setLogwrapper(LoggerWrapper logwrapper) {
		LoggerWrapper.logwrapper = logwrapper;
	}
	public void debug(Object message) {
        log.debug(message);
    }

    public void debug(Object message, Throwable t) {
        log.debug(message, t);
    }

	public void error(Object arg0, Throwable arg1) {
		log.error(arg0, arg1);
	}

	public void error(Object arg0) {
		log.error(arg0);
	}

	public void fatal(Object arg0, Throwable arg1) {
		log.fatal(arg0, arg1);
	}

	public void fatal(Object arg0) {
		log.fatal(arg0);
	}

	public void info(Object arg0, Throwable arg1) {
		log.info(arg0, arg1);
	}

	public void info(Object arg0) {
		log.info(arg0);
	}

	public boolean isDebugEnabled() {
		return log.isDebugEnabled();
	}


	public boolean isInfoEnabled() {
		return log.isInfoEnabled();
	}

	public boolean isTraceEnabled() {
		return log.isTraceEnabled();
	}


	public void trace(Object arg0, Throwable arg1) {
		log.trace(arg0, arg1);
	}

	public void trace(Object arg0) {
		log.trace(arg0);
	}

	public void warn(Object arg0, Throwable arg1) {
		log.warn(arg0, arg1);
	}

	public void warn(Object arg0) {
		log.warn(arg0);
	}

 }
