/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Template.java,v 1.17 2008/07/08 15:28:19 jtodd Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.ps.common;

import java.util.Locale;

import org.eclipse.cosmos.internal.dr.ps.common.Configuration;


/**
 * This class provides a bean to hold boot strap information to set up the user interface    
 * page.  
 */
public class Template {
	
	public static final String NAMESPACE_QUERY = "http://cmdbf.org/schema/1-0-0/query"; //$NON-NLS-1$
	
	protected String page;	
	protected String debugContainer;	
	protected String dojoPath;
	protected String dojoBaseUrl;
	protected String cosmosBaseURL;
	protected String serviceBaseURL = ""; //$NON-NLS-1$
	protected Locale locale;
        
	public void initialize(Configuration configuration) throws Exception{
		dojoPath = configuration.getValue("DOJO_PATH");  //$NON-NLS-1$
		dojoBaseUrl = configuration.getValue("DOJO_BASE_URL"); //$NON-NLS-1$
		cosmosBaseURL = configuration.getValue("COSMOS_BASE_URL");  //$NON-NLS-1$
		serviceBaseURL = configuration.getValue("COSMOS_SERVICE_BASE_URL");			 //$NON-NLS-1$
		page = configuration.getValue("DEFAULT_PAGE_TEMPLATE");			 //$NON-NLS-1$
	}
	
	/**
	 * Sets the base url that contains the dojo scripts
	 * @param dojoBaseUrl the base url that contains the dojo scripts
	 */
	public void setDojoBaseURL(String dojoBaseUrl){
		this.dojoBaseUrl = dojoBaseUrl; 
	}	

	/**
	 * The base url that contains the dojo scripts
	 * @return the base url of the dojo scripts
	 */
	public String getDojoBaseUrl() {
		return dojoBaseUrl;
	}


	/**
	 * Sets the path to the dojo.js file
	 * @param dojoPath the path to the dojo.js file
	 */
	public void setDojoPath(String dojoPath) {
		this.dojoPath = dojoPath;
	}

	/**
	 * Returns the base url for the COSMOS services
	 * @return
	 */
	public String getServiceBaseURL() {
		return serviceBaseURL;
	}
	/**
	 * Sets the base url for the COSMOS services
	 * @param serviceBaseURL the base path
	 */
	public void setServiceBaseURL(String serviceBaseURL) {
		this.serviceBaseURL = serviceBaseURL;
	}

	/**
	 * Generates html output that represents required header text (i.e. includes required scripts and dojo types).
	 * @return html output
	 */
	public String header(){
		if (cosmosBaseURL == null)
			cosmosBaseURL = "js/org/eclipse/cosmos"; //$NON-NLS-1$
		if (serviceBaseURL == null)
			serviceBaseURL = ""; //$NON-NLS-1$
		StringBuffer out = new StringBuffer();
		
		//include dojo
		out.append("<script type=\"text/javascript\">"). //$NON-NLS-1$
		append("djConfig= {isDebug:").append(((debugContainer != null)?"true":"false")).append(","). //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		append("locale: \""+locale.getLanguage().replace('_', '-')+"\","). //$NON-NLS-1$ //$NON-NLS-2$
		append("useXDomain: true,"). //$NON-NLS-1$
		append("baseUrl: \"./\","). //$NON-NLS-1$
		append("cosmosWidgetService: \""+serviceBaseURL+"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/widget/WidgetProperties\","). //$NON-NLS-1$ //$NON-NLS-2$		
		append("parseOnLoad: true,"). //$NON-NLS-1$
		append("xdWaitSeconds: 5 };"). //$NON-NLS-1$
		append("</script>\n"); //$NON-NLS-1$
		out.append("<script type=\"text/javascript\" src=\""+dojoPath+"\"></script>\n"); //$NON-NLS-1$ //$NON-NLS-2$

		//assume cosmos widgets are stored under '../cosmos' relative to the dojo widget library
		out.append("<script>").				 //$NON-NLS-1$
		append("dojo.registerModulePath(\"dojo\",\""+dojoBaseUrl+"/dojo\");"). //$NON-NLS-1$ //$NON-NLS-2$
		append("dojo.registerModulePath(\"dojox\",\""+dojoBaseUrl+"/dojox\");"). //$NON-NLS-1$ //$NON-NLS-2$
		append("dojo.registerModulePath(\"dijit\",\""+dojoBaseUrl+"/dijit\");"). //$NON-NLS-1$ //$NON-NLS-2$
		append("dojo.registerModulePath(\"org.eclipse.cosmos\",\""+cosmosBaseURL+"\");"). //$NON-NLS-1$ //$NON-NLS-2$
		append("dojo.registerModulePath(\"nls.org.eclipse.cosmos\",\""+cosmosBaseURL+"/../../../nls/org/eclipse/cosmos\");"). //$NON-NLS-1$ //$NON-NLS-2$
		append("dojo.require(\"dijit.dijit\");").		 //$NON-NLS-1$
//		append("dojo.require(\"dijit.dijit-all\");").		
		append("dojo.require(\"org.eclipse.cosmos.provisional.dr.ps.components.widget.common\");").		 //$NON-NLS-1$
		append("dojo.require(\"org.eclipse.cosmos.provisional.dr.ps.components.utility.common\");").		 //$NON-NLS-1$
		append("dojo.require(\"dojo.parser\");").		 //$NON-NLS-1$
		append("</script>");		 //$NON-NLS-1$
		return out.toString();
	}
	
	/**
	 * Sets the page id to load
	 * @param page id representing the page to load
	 */
 	public void setPage(String page){
 		this.page  = page;
 	}
 	
 	/**
 	 * Returns the page id that is loaded
 	 * @return the page id representing the page to load
 	 */
 	public String getPage(){
		return IConstants.PAGES_DIR+"/"+page; //$NON-NLS-1$
	}
 	
 	/**
 	 * Sets debug flag
 	 * @param debug
 	 */
 	public void setDebug(String debug){
 		debugContainer = debug;
 	}
	
 	/**
 	 * Returns debug flag
 	 * @return
 	 */
 	public String getDebug(){
 		return debugContainer;
 	}

	public String getCosmosBaseURL() {
		return cosmosBaseURL;
	}

	public void setCosmosBaseURL(String cosmosBaseURL) {
		this.cosmosBaseURL = cosmosBaseURL;
	}

	public Locale getLocale() {
		return locale;
	}

	public void setLocale(Locale locale) {
		this.locale = locale;
	}

}
