/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDDTypeResolver {
    private static final String ddFileName = "sdd-deploymentDescriptor-1.0.xsd";
    private static final String pdFileName = "sdd-packageDescriptor-1.0.xsd";
    private static final String commonFileName = "sdd-common-1.0.xsd";
    private static final String xmldsigFileName = "xmldsig-core-schema.xsd";
    private static final String ddPrefix = "sdd-dd:";
    private static final String pdPrefix = "sdd-pd:";
    private static final String commonPrefix = "sdd-common:";
    private static final String xmldsigPrefix = "ds:";
    private Document ddDocument = this.loadDocumentFromSchema("sdd-deploymentDescriptor-1.0.xsd");
    private Document pdDocument = this.loadDocumentFromSchema("sdd-packageDescriptor-1.0.xsd");
    private Document commonDocument = this.loadDocumentFromSchema("sdd-common-1.0.xsd");
    private Document xmldsigDocument = this.loadDocumentFromSchema("xmldsig-core-schema.xsd");

    public Collection<Element> resolveSDDType(String sddTypeName) {
        Element rootElement = null;
        if (sddTypeName.startsWith(ddPrefix)) {
            rootElement = this.ddDocument.getDocumentElement();
        } else if (sddTypeName.startsWith(pdPrefix)) {
            rootElement = this.pdDocument.getDocumentElement();
        } else if (sddTypeName.startsWith(commonPrefix)) {
            rootElement = this.commonDocument.getDocumentElement();
        } else if (sddTypeName.startsWith(xmldsigPrefix)) {
            rootElement = this.xmldsigDocument.getDocumentElement();
        }
        if (rootElement == null) {
            return null;
        }
        Element typeElement = this.findComplexType(rootElement, this.stripPrefix(sddTypeName));
        if (typeElement == null) {
            return null;
        }
        Collection<Element> childElements = this.findChildElements(typeElement);
        return childElements;
    }

    public String stripPrefix(String typeName) {
        int index = typeName.indexOf(58);
        if (index != -1) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    private Document loadDocumentFromSchema(String schemaFileName) throws FileNotFoundException, IOException, SAXException {
        InputStream inStream = this.loadSchemaFromJar(schemaFileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document xmlDocument = builder.parse(inStream);
        this.removeWhitespaceNodes(xmlDocument.getDocumentElement());
        return xmlDocument;
    }

    private void removeWhitespaceNodes(Element e) {
        NodeList children = e.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                e.removeChild(child);
            } else if (child instanceof Element) {
                this.removeWhitespaceNodes((Element)child);
            }
            --i;
        }
    }

    private Element findComplexType(Element rootElement, String typeName) {
        String elementType;
        if (rootElement.getNodeName().equals("xsd:complexType") && (elementType = rootElement.getAttribute("name")) != null && typeName.equals(elementType)) {
            return rootElement;
        }
        NodeList children = rootElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            if (children.item(i) instanceof Element && (element = this.findComplexType((Element)children.item(i), typeName)) != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private Collection<Element> findChildElements(Element rootElement) {
        Collection<Element> groupElements;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (rootElement.getNodeName().equals("xsd:group") && (groupElements = this.expandGroupReference(rootElement)) != null) {
            elements.addAll(groupElements);
        }
        if (rootElement.getNodeName().equals("xsd:element")) {
            elements.add(rootElement);
        }
        NodeList children = rootElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                elements.addAll(this.findChildElements((Element)children.item(i)));
            }
            ++i;
        }
        return elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<Element> expandGroupReference(Element refElement) {
        Element docElement = null;
        if (refElement.getAttribute("ref") == null) return null;
        if (refElement.getAttribute("ref").startsWith(ddPrefix)) {
            docElement = this.ddDocument.getDocumentElement();
        } else if (refElement.getAttribute("ref").startsWith(pdPrefix)) {
            docElement = this.pdDocument.getDocumentElement();
        } else if (refElement.getAttribute("ref").startsWith(commonPrefix)) {
            docElement = this.commonDocument.getDocumentElement();
        } else {
            if (!refElement.getAttribute("ref").startsWith(xmldsigPrefix)) return null;
            docElement = this.xmldsigDocument.getDocumentElement();
        }
        String groupName = refElement.getAttribute("ref");
        groupName = groupName.substring(groupName.indexOf(58) + 1);
        Element groupElement = this.findGroup(docElement, groupName);
        return this.findChildElements(groupElement);
    }

    private Element findGroup(Element rootElement, String groupName) {
        String elementName;
        if (rootElement.getNodeName().equals("xsd:group") && (elementName = rootElement.getAttribute("name")) != null && elementName.equals(groupName)) {
            return rootElement;
        }
        NodeList children = rootElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            if (children.item(i) instanceof Element && (element = this.findGroup((Element)children.item(i), groupName)) != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private InputStream loadSchemaFromJar(String schemaToLoad) throws FileNotFoundException {
        InputStream in = SDDTypeResolver.class.getResourceAsStream("/sdd_schema/" + schemaToLoad);
        if (in == null) {
            in = new FileInputStream(new File("sdd_schema/" + schemaToLoad));
        }
        return in;
    }
}

