/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <recordConstraint> element containing a collection of property value and record type
 * artifacts
 * 
 * 
 * @author David Whiteman
 */
public interface IRecordConstraint extends IConstraint, IXMLWritable {
	public void addPropertyValue(IPropertyValue propertyValue);
	
	public IPropertyValue[] getPropertyValues();
	
	public void addRecordType(IRecordType recordType);
	
	public IRecordType[] getRecordTypes();
}
