/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;


/**
 * Represents the <relationship> element from a query response
 * 
 * 
 * @author Ali Mehregani
 */
public interface IRelationship extends IGraphElement {
	/**
	 * Answer the {@link IInstanceId} of the source item in the relationship
	 * 
	 * @return
	 */
	public IInstanceId getSourceId();

	/**
	 * Set the {@link IInstanceId} of the source item in the relationship
	 * 
	 * @param sourceItem
	 */
	public void setSourceId(IInstanceId sourceItem);

	/**
	 * Answer the {@link IInstanceId} of the target item in the relationship
	 * 
	 * @return
	 */
	public IInstanceId getTargetId();

	/**
	 * Set the {@link IInstanceId} of the target item in the relationship
	 * 
	 * @param targetItem
	 */
	public void setTargetId(IInstanceId targetItem);
}
