/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IOutputter.java,v 1.2 2008/01/04 21:44:30 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

import java.io.PrintWriter;
import java.util.List;
/**
 * Provides data feeds  
 */
public interface IOutputter {

	/**
	 * A resolver class that will generate unique ids.  unique ids 
	 * may be required by the outputter to identify particular items in 
	 * the generated output.
	 * @param idResolver id resolving class
	 */
	public abstract void setIdResolver(IIDResolver idResolver);

	/**
	 * Writes content to a PrintWriter.  An input map is passed to this method 
	 * that the render method will use to generate the data feed
	 * @param output a PrintWriter that method will write to
	 * @param input an input map that contains name value pairs
	 * @throws Exception 
	 */
	public abstract void render(PrintWriter output, IParameters input)	throws Exception;

	/**
	 * This method is called write after instantiating the outputer. 
	 * @param context outputter context that contains a persistent storage object and other context apis
	 * @param parameters an input map that contains name value pairs
	 * @throws Exception
	 */
	public abstract void initalize(IOutputterContext context, IParameters parameters)	throws Exception;
	
	public abstract List<IOutputterParameters> getInvalidInput(IParameters input) throws Exception;
	
	public abstract IOutputterParameters[] getInputParameters();	
	
}
