/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;

/**
 * Common constants used by multiple classes under different
 * packages.
 * 
 * @author Ali Mehregani
 */
public class ISMLRepositoryConstants
{
	private ISMLRepositoryConstants() {} // do not instantiate
	
	/**
	 * The repository meta-data filename
	 */
	public static final String METADATA_REPOSITORY = ".smlif_meta";
	
	/**
	 * XML declaration
	 */
	public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
	
	/**
	 * The name-space prefix
	 */
	public static final String SMLIF_NAMESPACE_PREFIX = "smlif";
	
	/**
	 * Fragments needed as part of forming an SML-IF document
	 */
	public static final String smlifStart = new StringBuffer(ISMLConstants.XML_PREAMBLE).append(ISMLConstants.nl).append(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET).append(SMLIF_NAMESPACE_PREFIX).append(ICMDBfServicesConstants.COLON).append(ISMLConstants.MODEL_ELEMENT).append(ISMLConstants.nl).
		append(ISMLConstants.tab).append("xmlns:smlif=\"").append(ISMLConstants.SMLIF_URI).append(ICMDBfServicesConstants.DOUBLE_QUOTE).append(ISMLConstants.nl).
		append(ISMLConstants.tab).append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema").append(ICMDBfServicesConstants.DOUBLE_QUOTE).append(ISMLConstants.nl).append(ISMLConstants.tab).append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(ISMLConstants.nl).append(ISMLConstants.tab).append("xsi:schemaLocation=\"").
		append(ISMLConstants.SMLIF_URI).append(" smlif.xsd\">").append(ISMLConstants.nl).toString();
	public static final String ruleBindingsStart = new StringBuffer(ISMLConstants.tab).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.RULEBINDINGS_ELEMENT)).append(ISMLConstants.nl).toString();
	public static final String ruleBindingsEnd = new StringBuffer(ISMLConstants.tab).append(SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.RULEBINDINGS_ELEMENT)).append(ISMLConstants.nl).toString();
	public static final String definitionsStart = SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DEFINITIONS_ELEMENT) + ISMLConstants.nl;
	public static final String instancesStart = SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.INSTANCES_ELEMENT) + ISMLConstants.nl;
	public static final String docAliasesStart = new StringBuffer(ISMLConstants.nl).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DOCUMENT_ELEMENT)).append(ISMLConstants.nl).append(ISMLConstants.tab).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DOC_INFO_ELEMENT)).append(ISMLConstants.nl).append(ISMLConstants.tab).append(ISMLConstants.tab).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.ALIASES_ELEMENT)).toString();
	public static final String docAliasesEnd = new StringBuffer(ISMLConstants.nl).append(ISMLConstants.tab).append(ISMLConstants.tab).append(SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.ALIASES_ELEMENT)).append(ISMLConstants.nl).append(ISMLConstants.tab).append(SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DOC_INFO_ELEMENT)).append(ISMLConstants.nl).append(ISMLConstants.tab).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DATA_ELEMENT)).toString();
	public static final String docDataEnd = new StringBuffer(ISMLConstants.tab).append(SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DATA_ELEMENT)).append(ISMLConstants.nl).append(SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DOCUMENT_ELEMENT)).append(ISMLConstants.nl).toString();
	public static final String docAliasStart = new StringBuffer(ISMLConstants.nl).append(ISMLConstants.tab).append(ISMLConstants.tab).append(ISMLConstants.tab).append(SMLValidatorUtil.beginTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.ALIAS_ELEMENT)).toString();
	public static final String docAliasEnd = SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.ALIAS_ELEMENT);	
	public static final String smlifEnd = SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.MODEL_ELEMENT);
	public static final String definitionsEnd = SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.DEFINITIONS_ELEMENT) + ISMLConstants.nl;
	public static final String instancesEnd = SMLValidatorUtil.endTagFor(ISMLRepositoryConstants.SMLIF_NAMESPACE_PREFIX, ISMLConstants.INSTANCES_ELEMENT) + ISMLConstants.nl;		

	/**
	 * Elements
	 */
	public static final String FACETS_ELEMENT = "facets";
	public static final String FACET_ELEMENT = "facet";
	public static final String FACET_REF_ELEMENT = "facetRef";
	public static final String PROPERTIES_ELEMENT = "properties";	
	public static final String PROPERTY_REF_ELEMENT = "propertyRef";
	public static final String ITEM_REF_ELEMENT = "itemRef";
	
	/**
	 * Attributes
	 */
	public static final String NAME_ATTRIBUTE = "name";
	public static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
	public static final String DESCRIPTION_ATTRIBUTE = "description";

	/**
	 * Types
	 */
	public static final String ITEM_TYPE = "itemType";
	public static final String FACETS_TYPE = "facetsType";
	public static final String FACET_TYPE = "facetBaseType";
	public static final String PROPERTIES_TYPE = "propertiesType";
	public static final String PROPERTY_TYPE = "propertyBaseType";	
	
	/**
	 * URIs
	 */
	public static final String URI_ITEM = "http://www.cosmos.rm/dataCenter/core";
}
