/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.BaseFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DeploymentDescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageDescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SDDTypeResolver;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementFactoryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.SchemaTypePattern;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.VariableFactoryImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.BaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Descriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.VariableFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPISessionImpl
implements SPISession {
    private static SPISessionImpl defaultSession = null;
    private Document ddDocument = null;
    private Document pdDocument = null;
    private Document commonDocument = null;
    private Document xmlDsigDocument = null;
    private DocumentBuilder builder = null;
    private boolean performHardErrorChecking = true;
    private boolean useCopies = true;
    private final Logger log = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.common.spi.default");
    private SDDTypeResolver sddTypeResolver = null;

    public static SPISessionImpl getDefaultSession() {
        if (defaultSession == null) {
            defaultSession = new SPISessionImpl();
        }
        return defaultSession;
    }

    SPISessionImpl() {
        this.log.setUseParentHandlers(false);
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.ddDocument = this.builder.newDocument();
        this.pdDocument = this.builder.newDocument();
        this.commonDocument = this.builder.newDocument();
        this.xmlDsigDocument = this.builder.newDocument();
        try {
            this.sddTypeResolver = new SDDTypeResolver();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArtifactFactory createArtifactFactory() {
        return new ArtifactFactoryImpl(this);
    }

    @Override
    public BaseFactory createBaseFactory() {
        return new BaseFactoryImpl(this);
    }

    @Override
    public ConditionFactory createConditionFactory() {
        return new ConditionFactoryImpl(this);
    }

    @Override
    public ContentUnitFactory createContentUnitFactory() {
        return new ContentUnitFactoryImpl(this);
    }

    @Override
    public RequiredBaseFactory createRequiredBaseFactory() {
        return new RequiredBaseFactoryImpl(this);
    }

    @Override
    public RequirementFactory createRequirementFactory() {
        return new RequirementFactoryImpl(this);
    }

    @Override
    public VariableFactory createVariableFactory() {
        return new VariableFactoryImpl(this);
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    public Document getDdDocument() {
        return this.ddDocument;
    }

    public Document getPdDocument() {
        return this.pdDocument;
    }

    public Document getCommonDocument() {
        return this.commonDocument;
    }

    public void setHardErrorChecking(boolean hardErrorChecking) {
        this.performHardErrorChecking = hardErrorChecking;
    }

    public boolean isErrorCheckingEnabled() {
        return this.performHardErrorChecking;
    }

    public boolean isUseCopy() {
        return this.useCopies;
    }

    public void setUseCopy(boolean copies) {
        this.useCopies = copies;
    }

    public void testParameter(Object param, int paramNumber, SchemaTypePattern pattern) {
        boolean isValid = true;
        Level logLevel = this.performHardErrorChecking ? Level.SEVERE : Level.WARNING;
        InvalidInputException e = null;
        if (param == null) {
            e = new InvalidInputException(paramNumber, 0);
            isValid = false;
            this.log.log(logLevel, e.toString(), e);
        } else if (param instanceof byte[]) {
            if (((byte[])param).length == 0) {
                e = new InvalidInputException(paramNumber, 2);
                isValid = false;
                this.log.log(logLevel, e.toString(), e);
            }
        } else if (param.getClass().isArray() && ((Object[])param).length == 0) {
            e = new InvalidInputException(paramNumber, 2);
            isValid = false;
            this.log.log(logLevel, e.toString(), e);
        } else if (param instanceof Collection && ((Collection)param).isEmpty()) {
            e = new InvalidInputException(paramNumber, 6);
            isValid = false;
            this.log.log(logLevel, e.toString(), e);
        }
        if (this.performHardErrorChecking && !isValid) {
            throw e;
        }
    }

    public void testIntParameter(int param, int paramNumber, int[] validValues) {
        boolean isValid = false;
        InvalidInputException e = null;
        int i = 0;
        while (i < validValues.length && !isValid) {
            if (param == validValues[i]) {
                isValid = true;
            }
            ++i;
        }
        if (!isValid) {
            e = new InvalidInputException(paramNumber, 4);
            this.handleInputException(e);
        }
    }

    public void testCollectionParameter(Collection param, int paramNumber, int minSize, int maxSize) {
        boolean isValid = false;
        InvalidInputException e = null;
        if (param != null && (maxSize <= -1 || param.size() <= maxSize) && param.size() >= minSize) {
            isValid = true;
        }
        if (this.performHardErrorChecking && !isValid) {
            e = new InvalidInputException(paramNumber, 4);
            this.handleInputException(e);
        }
    }

    public void handleInputException(InvalidInputException e) {
        Level logLevel = this.performHardErrorChecking ? Level.SEVERE : Level.WARNING;
        this.log.log(logLevel, e.toString(), e);
        if (this.performHardErrorChecking) {
            throw e;
        }
    }

    public Element createDeploymentElement(String tagName) {
        Element e = this.ddDocument.createElementNS("http://docs.oasis-open.org/sdd/ns/deploymentDescriptor", "sdd-dd:" + tagName);
        return e;
    }

    public Element createPackageElement(String tagName) {
        Element e = this.pdDocument.createElementNS("http://docs.oasis-open.org/sdd/ns/packageDescriptor", "sdd-pd:" + tagName);
        return e;
    }

    public Element createCommonElement(String tagName) {
        Element e = this.commonDocument.createElementNS("http://docs.oasis-open.org/sdd/ns/common", "sdd-common:" + tagName);
        return e;
    }

    public Element createXmlDsigElement(String tagName) {
        Element e = this.xmlDsigDocument.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:" + tagName);
        return e;
    }

    public void insertNode(Node parent, Node node, String parentSchemaType) {
        if (parent instanceof Document) {
            ((Document)parent).adoptNode(node);
            parent.appendChild(node);
        } else {
            parent.getOwnerDocument().adoptNode(node);
            Collection<Element> allowedChildNodes = this.sddTypeResolver.resolveSDDType(parentSchemaType);
            Collection<Element> children = this.getChildren(parent);
            String nodeName = this.sddTypeResolver.stripPrefix(node.getNodeName());
            boolean foundNode = false;
            Iterator<Element> allowedIter = allowedChildNodes.iterator();
            while (allowedIter.hasNext()) {
                Element nextAllowedElement = allowedIter.next();
                if (!nextAllowedElement.getAttribute("name").equals(nodeName)) continue;
                foundNode = true;
                if (allowedIter.hasNext()) {
                    boolean insertedNode = false;
                    while (allowedIter.hasNext() && !insertedNode) {
                        nextAllowedElement = allowedIter.next();
                        Iterator<Element> childrenIter = children.iterator();
                        while (childrenIter.hasNext() && !insertedNode) {
                            Element child = childrenIter.next();
                            String childName = this.sddTypeResolver.stripPrefix(child.getNodeName());
                            if (!nextAllowedElement.getAttribute("name").equals(childName)) continue;
                            insertedNode = true;
                            parent.insertBefore(node, child);
                        }
                    }
                    if (insertedNode) continue;
                    parent.appendChild(node);
                    continue;
                }
                parent.appendChild(node);
            }
            if (!foundNode) {
                parent.appendChild(node);
                this.log.warning("Adding element " + node.getNodeName() + " as a child of " + parent.getNodeName() + ", but " + node.getNodeName() + " is not in the list of allowed children.");
            }
        }
    }

    public void insertNode(Node parent, SPIDataObject node, String parentSchemaType) {
        this.insertNode(parent, (Node)node.getElement(), parentSchemaType);
    }

    public void insertNode(SPIDataObject parent, Node node, String parentSchemaType) {
        this.insertNode((Node)parent.getElement(), node, parentSchemaType);
    }

    public void insertNode(SPIDataObject parent, SPIDataObject node, String parentSchemaType) {
        this.insertNode((Node)parent.getElement(), (Node)node.getElement(), parentSchemaType);
    }

    public Collection<Element> getChildren(Node parent, String nodeName) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        Collection<Element> nodeList = this.getChildren(parent);
        for (Element element : nodeList) {
            if ((element.getLocalName() == null || !element.getLocalName().equals(nodeName) && !nodeName.endsWith(":" + element.getLocalName())) && !element.getNodeName().equals(nodeName) && !element.getNodeName().endsWith(":" + nodeName)) continue;
            nodes.add(element);
        }
        return nodes;
    }

    public Collection<Element> getChildren(Node parent) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                nodes.add((Element)node);
            }
            ++i;
        }
        return nodes;
    }

    public Element getChild(Node parent, String nodeName) {
        Element element = null;
        Collection<Element> nodes = this.getChildren(parent, nodeName);
        if (!nodes.isEmpty()) {
            element = nodes.iterator().next();
        }
        return element;
    }

    public Element getChild(Node parent) {
        Collection<Element> nodes = this.getChildren(parent);
        return nodes.iterator().next();
    }

    public void removeChildren(Node parent, String nodeName) {
        Collection<Element> nodes = this.getChildren(parent, nodeName);
        for (Element e : nodes) {
            parent.removeChild(e);
        }
    }

    @Override
    public Descriptor buildDescriptorFromDocument(Document doc) throws InvalidInputException {
        this.log.entering(this.getClass().getName(), "getDescriptor");
        this.testParameter(doc, 1, null);
        DescriptorImpl d = null;
        if (doc.getDocumentElement().getNodeName().equals("sdd-dd:DeploymentDescriptor")) {
            d = new DeploymentDescriptorImpl(doc, this);
        } else if (doc.getDocumentElement().getNodeName().equals("sdd-pd:PackageDescriptor")) {
            d = new PackageDescriptorImpl(doc, this);
        } else {
            throw new InvalidInputException(1, 4);
        }
        this.log.exiting(this.getClass().getName(), "getDescriptor");
        return d;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }
}

