/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import java.util.Collection;

/**
 * The InstallableUnit element is an atomic content element that defines artifacts that install or update software 
 * and defines requirements for applying those artifacts. It may also define artifacts that undo an update or that 
 * uninstall or repair existing software.
 */
public interface InstallableUnit extends InstallUnit 
{
    /**
     * Gets the installable unit completion action.
     * 
     * A Completion element MUST be included if the artifact being processed requires a system operation such as a reboot 
     * or logoff to occur to function successfully after deployment or if the artifact executes a system operation to 
     * complete deployment of the contents of the artifact.<br><br>
     * There MUST be an artifact associated with the operation defined by a Completion element. 
     * <ul>For example, if there is a Completion element for the install operation, the InstallableUnit must define an 
     * InstallArtifact.</ul>
     *  
     * @return A colleciton of Completion objects that describe completion actions such as restart and the conditions 
     * under which the action is applied.
     */
    Collection<Completion> getInstallableUnitCompletion();
	
    /**
     * Gets the resulting change.
     * 
     * Multiple content elements within the SDD MAY specify the same resource in their ResultingChange elements. In this 
     * case each content element is capable of modifying the configuration of that resource.<br><br>
     * An example use of the ResultingChange element is to understand whether or not one content element can satisfy the 
     * requirements specified in another content element.
     * 
     * @return A collection of ResultingChange that will be configured by processing the InstallableUnits artifacts.
     */
    Collection<ResultingChange> getResultingChanges();	
	
	/**
	 * Sets the installable unit completion action.
	 * 
     * A Completion element MUST be included if the artifact being processed requires a system operation such as a reboot 
     * or logoff to occur to function successfully after deployment or if the artifact executes a system operation to 
     * complete deployment of the contents of the artifact.<br><br>
     * There MUST be an artifact associated with the operation defined by a Completion element. 
     * <ul>For example, if there is a Completion element for the install operation, the InstallableUnit must define an 
     * InstallArtifact.</ul>
     * 
	 * @param installableUnitCompletion A collection of Completion objects that describe completion actions such as 
	 * restart and the conditions under which the action is applied.
	 * 
	 */
	void setCompletion(Collection<Completion> installableUnitCompletion);
	
	/**
	 * Sets the resulting changes.
	 * 
     * Multiple content elements within the SDD MAY specify the same resource in their ResultingChange elements. In this 
     * case each content element is capable of modifying the configuration of that resource.<br><br>
     * An example use of the ResultingChange element is to understand whether or not one content element can satisfy the 
     * requirements specified in another content element.
     * 
	 * @param resultingChanges A collection of ResultingChange that will be configured by processing the InstallableUnits artifacts.
	 */
	void setResultingChanges(Collection<ResultingChange> resultingChanges);

}
