/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;

public class RelationshipType {
	
	/*
	 * <RelationshipType> 	 	 	 	
		relatedResourceRef 	xsd:IDREF 	Yes
		type 	xsd:QName 	Yes
		any 	namespace="##other" 	 ?
		Property 		<PropertyType> 	Yes
		any 		namespace="##other" 	 ? 
	 */

	public static Collection<Relationship> merge(Collection<Relationship> relationships1, Collection<Relationship> relationships2)
	{
		Collection <Relationship> relationshipsToRemove = new ArrayList <Relationship> ();
		Iterator <Relationship> relationshipIter1 = relationships1.iterator();		
		//iterate through the relationships
		while (relationshipIter1.hasNext())
		{
			Relationship relationship1 = (Relationship) relationshipIter1.next();
			Iterator <Relationship> relationshipIter2 = relationships2.iterator();
			while (relationshipIter2.hasNext())
			{
				Relationship relationship2 = (Relationship) relationshipIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (relationshipsToRemove.contains(relationship2)==false)
				{
					if (equals(relationship1, relationship2))
					{  //merge hosted relationships, types and description groups
						relationshipsToRemove.add(relationship2);						
						relationship1 = merge(relationship1,relationship2);
						
					}
				}
					
			}
		}
		
		relationships2.removeAll(relationshipsToRemove);
		//remove all of the matches that were found
		
		Collection <Relationship> finalRelationships = new ArrayList <Relationship> ();
		//create and return a new collection with all of the remaining items
		finalRelationships.addAll(relationships1);
		finalRelationships.addAll(relationships2);		
		
		return finalRelationships;
		
	}
	
	public static boolean equals(Relationship relationship1, Relationship relationship2)
	{
		if (!ResourceType.equals(Util.resolveResourceRef(relationship1.getRelatedResourceReference()), Util.resolveResourceRef(relationship2.getRelatedResourceReference())))
			return false;
		if (!StringType.equals(relationship1.getType(), relationship2.getType()))
			return false;
		if (!PropertyType.equals(relationship1.getProperties(), relationship2.getProperties()))
			return false;
		
		return true;
	}
	
	public static Relationship merge(Relationship relationship1, Relationship relationship2)
	{
		return relationship1;
	}

}
