/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;

public class ResourceMapType {
	
	public static Collection <ResourceMap> merge (   Collection <ResourceMap> resourceMaps1, Collection <ResourceMap> resourceMaps2)
	{

		Collection <ResourceMap> resourceMapsToRemove = new ArrayList <ResourceMap> ();
		Iterator <ResourceMap> resourceMapIter1 = resourceMaps1.iterator();		
		//iterate through the resourceMaps
		while (resourceMapIter1.hasNext())
		{
			ResourceMap resourceMap1 = (ResourceMap) resourceMapIter1.next();
			Iterator <ResourceMap> resourceMapIter2 = resourceMaps2.iterator();
			while (resourceMapIter2.hasNext())
			{
				ResourceMap resourceMap2 = (ResourceMap) resourceMapIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (resourceMapsToRemove.contains(resourceMap2)==false)
				{
					if (equals(resourceMap1, resourceMap2))
					{  //merge hosted resourceMaps, types and description groups
						resourceMapsToRemove.add(resourceMap2);						
						resourceMap1 = merge(resourceMap1,resourceMap2);
						
					}
				}
					
			}
		}
		
		resourceMaps2.removeAll(resourceMapsToRemove);
		//remove all of the matches that were found
		
		Collection <ResourceMap> finalResourceMaps = new ArrayList <ResourceMap> ();
		//create and return a new collection with all of the remaining items
		finalResourceMaps.addAll(resourceMaps1);
		finalResourceMaps.addAll(resourceMaps2);		
		
		return finalResourceMaps;
		
	}

	private static ResourceMap merge(ResourceMap resourceMap1, ResourceMap resourceMap2)
	{		
		return resourceMap1;
	}

	private static boolean equals(ResourceMap map1, ResourceMap map2)
	{
		if (ResourceType.equals(Util.resolveResourceRef(map1.getResourceReference()),Util.resolveResourceRef(map1.getResourceReference())))
		{
			if ((map1.getForeignID()!=null)&&(map2.getForeignID()==null))
				return false;
			if ((map1.getForeignID()==null)&&(map2.getForeignID()!=null))
				return false;
			if ((map1.getForeignID()!=null)&&(map2.getForeignID()!=null))			
			{
				if (StringType.equals(map1.getForeignID(), map2.getForeignID()))
					return true;
			}
			else return true;
		}
			
		return false;
	}
}
