/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;

public class ValidationSet {
    private List<ElementSchemaModel> definitions = new ArrayList<ElementSchemaModel>();
    private Map<String, ElementSchemaModel> definitionsByNamespace;
    private List<ElementModel> instances = new ArrayList<ElementModel>();

    public ValidationSet() {
        this.definitionsByNamespace = new Hashtable<String, ElementSchemaModel>();
    }

    public void addDefinitionDocument(ElementSchemaModel document) {
        this.definitionsByNamespace.put(document.getTargetNamespace(), document);
        this.definitions.add(document);
    }

    public void addInstanceDocument(ElementModel document) {
        this.instances.add(document);
    }

    public ElementSchemaModel[] getDefinitions() {
        return this.definitions.toArray(new ElementSchemaModel[this.definitions.size()]);
    }

    public ElementSchemaModel getDefinitionByNamespace(String namespace) {
        return this.definitionsByNamespace.get(namespace);
    }

    public ElementModel[] getInstances() {
        return this.instances.toArray(new ElementModel[this.instances.size()]);
    }

    public void addDefinitionDocuments(ElementSchemaModel[] definitions) {
        int i = 0;
        while (i < definitions.length) {
            this.addDefinitionDocument(definitions[i]);
            ++i;
        }
    }

    public void addInstanceDocuments(ElementModel[] instances) {
        int i = 0;
        while (i < instances.length) {
            this.addInstanceDocument(instances[i]);
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.definitions.size() + this.instances.size() == 0;
    }
}

