/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif;

import java.net.URL;

import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.rm.internal.repository.operations.IValidationOutputFactory;
import org.eclipse.cosmos.rm.internal.repository.operations.SMLMainValidator;
import org.eclipse.cosmos.rm.internal.smlif.validate.ui.MarkerOutput;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class SMLPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.cosmos.rm.smlif";

	// The shared instance
	private static SMLPlugin plugin;
	
	// Preference constants
	
	// Used to store the last output directory of an import operation
	public static final String IMPORT_OUTPUT_DIRECTORY = "import.output";
	
	/**
	 * The constructor
	 */
	public SMLPlugin() {
		plugin = this;
		
		SMLMainValidator.setEclipseValidationOutputFactory(new IValidationOutputFactory() {
			public AbstractValidationOutput createEclipseOutput() {
				return new MarkerOutput();
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception 
	{
		super.start(context);
		Runnable runnable = new Runnable() 
		{
			public void run() {
				try	
				{
					SMLImages.INSTANCE.initialize(new URL(getBundle().getEntry("/"), "icons/full/"), getImageRegistry());                    
				}
				catch(Exception e) 
				{
					e.printStackTrace();
				}
			}
		};
			
		if (Display.getDefault() == Display.getCurrent()) 
		{
            // We are in the main thread
			runnable.run();
		} 
		else 
		{
            // Post the initialization to the main thread
			Display.getDefault().asyncExec(runnable);
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static SMLPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
	/**
	 * Logs an error described by a text.
	 * 
	 * <p>This method should be whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logError(String text)
	{
		logError(new Throwable(text));
	}

	/**
	 * Logs an error described by a throwable.
	 * 
	 * <p>This method should be used whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param throwable
	 */
	public static void logError(Throwable throwable)
	{
		Status status = new Status(1, PLUGIN_ID, 0, throwable.toString(), throwable);
		getDefault().getLog().log(status);
	}
	
}
