/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.op;

import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public interface IOperationHandler {
	static final String QNAME = "qname"; // service property name

	public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation);
	public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation);
}
