/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener.event;

import org.eclipse.cosmos.me.sdd.op.listener.InstallationCompletionListener;

public interface InstallationCompletion extends InstallationCompletionListener {
	public static final String DESCRIPTION = "description";
	
	public enum Topic {
		FILTER("sdd/install/completion/*"),
		FAILURE("sdd/install/completion/failure"),
		CANCELLED("sdd/install/completion/cancelled"),
		COMPLETE("sdd/install/completion/complete"),
		UNKNOWN("unknown");
		
		private String value;
		
		Topic(String value) {
			this.value = value;
		}
		
		public String value() {
			return value;
		}
		
		public static Topic getValue(String value) {
			for (Topic t : values()) {
				if (t.value().equals(value)) return t;
			}
			return UNKNOWN;
		}
	}
}
